#ifndef __CONFIG_MOTOR_H
#define __CONFIG_MOTOR_H

/*# of pole pairs*/
#define POLE_PAIRS 3.0f

/*mechanical position offset,
  measured as +a, -b, -c (radians)*/
#define POS_OFFSET 5.88f

/*# of resolver lobes*/
#define RESOLVER_LOBES 3.0f

/*CPR of encoder or encoder emulator*/
#define CPR 4096

/*d and q axis inductances, henries*/
#define Ld 0.000876f
#define Lq 0.002068f

/*PM flux linkage, volt-seconds*/
#define FLUX_LINKAGE 0.06f

/*single phase resistance, ohms*/
#define Rs 0.05f

/*torque/phase amp for approximate models*/
#define KT 0.3f

/*a safe speed below which you 
  never need to field weaken*/
#define W_SAFE 100.0f

/*maximum sane mechanical speed,
  used to filter velocity (rad/s)*/
#define W_CRAZY 1500.0f

#define PI 3.141593f

#endif