#ifndef __CONFIG_LOOP_H
#define __CONFIG_LOOP_H

#include "config_inverter.h"

#define K_LOOP_D 2.5f
#define KI_BASE_D 0.025f

#define K_LOOP_Q 6.0f
#define KI_BASE_Q 0.01f

#define F_SLOW_LOOP 100.0f

#define INTEGRAL_MAX 1.0f

/*filter strengths, 0-1.0
  higher = stronger filtering*/
#define W_FILTER_STRENGTH 0.99f
#define DQ_FILTER_STRENGTH 0.95f
#define THROTTLE_FILTER_STRENGTH 0.0f


/*internally computed*/
#define KP_D (K_LOOP_D / BUS_VOLTAGE)
#define KI_D (KI_BASE_D * K_LOOP_D / BUS_VOLTAGE * 5000.0f / F_SW)

#define KP_Q (K_LOOP_Q / BUS_VOLTAGE)
#define KI_Q (KI_BASE_Q * K_LOOP_Q / BUS_VOLTAGE * 5000.0f / F_SW)

#define SLOW_LOOP_COUNTER ((int) (F_SW / F_SLOW_LOOP))

#endif