#include "mbed.h"
#include "CommandProcessor.h"
#include "PreferenceWriter.h"
#include "globals.h"

#include "config.h"
#include "config_driving.h"
#include "config_inverter.h"
#include "config_logging.h"
#include "config_loop.h"
#include "config_motor.h"
#include "config_pins.h"
#include "config_table.h"

void processCmd(Serial *pc, PreferenceWriter *pref, char *buf) {
    char *tokens[10];
    int len = tokenize(buf, tokens, 10);
    
    switch (len) {
    case 1:
        if (strcmp(tokens[0], "ls") == 0) cmd_ls(pc);
        if (strcmp(tokens[0], "defaults") == 0) cmd_defaults(pc);
        if (strcmp(tokens[0], "reload") == 0) cmd_reload(pc, pref);
        if (strcmp(tokens[0], "load") == 0) cmd_reload(pc, pref);
        if (strcmp(tokens[0], "flush") == 0) cmd_flush(pc, pref);
        if (strcmp(tokens[0], "mode") == 0) cmd_ls2(pc, tokens[0]);
        if (strcmp(tokens[0], "src") == 0) cmd_ls2(pc, tokens[0]);
        if (strcmp(tokens[0], "op") == 0) cmd_ls2(pc, tokens[0]);
        if (strcmp(tokens[0], "cfg") == 0) cmd_mode(pc, tokens[0]);
        if (strcmp(tokens[0], "zero") == 0) cmd_mode(pc, tokens[0]);
        if (strcmp(tokens[0], "wizard") == 0) cmd_mode(pc, tokens[0]);
        if (strcmp(tokens[0], "exit") == 0) cmd_exit(pc);
        break;
    case 2:
        if (strcmp(tokens[0], "ls") == 0) cmd_ls2(pc, tokens[1]);
        if (strcmp(tokens[0], "get") == 0) cmd_ls2(pc, tokens[1]);
        if (strcmp(tokens[0], "setp") == 0) cmd_setp(pc, tokens[1]);
        if (strcmp(tokens[0], "mode") == 0) cmd_mode(pc, tokens[1]);
        if (strcmp(tokens[0], "src") == 0) cmd_src(pc, tokens[1]);
        if (strcmp(tokens[0], "op") == 0) cmd_op(pc, tokens[1]);
        break;
    case 3:
        if (strcmp(tokens[0], "set") == 0) cmd_set(pc, tokens[1], tokens[2]);
    default:
        break;
    }
}