#ifndef __CONFIG_H
#define __CONFIG_H

#include "mbed.h"

/*---driving---*/
#define _TORQUE_MODE     __int_reg[0]
#define _MAX_TQPCT_PLUS  __float_reg[0]
#define _MAX_TQPCT_MINUS __float_reg[1]
#define _TORQUE_MAX      __float_reg[2]
#define _W_MAX           __float_reg[3]

/*---inverter---*/
#define _BUS_VOLTAGE     __float_reg[4]
#define _F_SW            __float_reg[5]

/*---logging---*/
#define _ENABLE_LOGGING  __int_reg[1]
#define _LOG_FREQUENCY   __float_reg[6]

/*---loop---*/
#define _K_LOOP_D        __float_reg[7]
#define _KI_BASE_D       __float_reg[8]

#define _K_LOOP_Q        __float_reg[9]
#define _KI_BASE_Q       __float_reg[10]

#define _F_SLOW_LOOP     __float_reg[11]

#define _INTEGRAL_MAX    __float_reg[12]

#define _W_FILTER_STRENGTH         __float_reg[13]
#define _DQ_FILTER_STRENGTH        __float_reg[14]
#define _THROTTLE_FILTER_STRENGTH  __float_reg[15]

#define _KP_D            __float_reg[17]
#define _KI_D            __float_reg[18]

#define _KP_Q            __float_reg[19]
#define _KI_Q            __float_reg[20]

#define _SLOW_LOOP_COUNTER __float_reg[21]

/*---motor---*/
#define _POLE_PAIRS      __float_reg[22]
#define _POS_OFFSET      __float_reg[23]
#define _RESOLVER_LOBES  __float_reg[24]
#define _CPR             __int_reg[2]
#define _Ld              __float_reg[25]
#define _Lq              __float_reg[26]
#define _FLUX_LINKAGE    __float_reg[27]
#define _Rs              __float_reg[28]
#define _KT              __float_reg[29]
#define _W_SAFE          __float_reg[30]
#define _W_CRAZY         __float_reg[31]

/*---rc_throttle---*/
#define _TH_LIMIT_LOW    __int_reg[3]
#define _TH_LIMIT_HIGH   __int_reg[4]
#define _TH_LIMIT_CRAZY  __int_reg[5]

/*---table---*/
#define _ROWS            __int_reg[6]
#define _COLUMNS         __int_reg[7]
#define _W_STEP          __float_reg[8]

/*---operating mode---*/

#define BREMS_mode             __int_reg[8]
#define BREMS_src              __int_reg[9]
#define BREMS_op               __int_reg[10]

/*internal variables and macros*/

extern float __float_reg[];
extern int __int_reg[];

#define DEFAULT(a) _##a = a
#define FPRINT(a) pc->printf("%s: %f\n", #a, _##a)
#define DPRINT(a) pc->printf("%s: %d\n", #a, _##a)

enum {
    MODE_RUN,
    MODE_CFG,
    MODE_ZERO,
    MODE_CHR,
};

enum {
    OP_TORQUE,
    OP_DRIVING,
    OP_SPEED,
    OP_POSITION,
};

enum {
    CMD_SRC_RC,
    CMD_SRC_ANALOG,
    CMD_SRC_TERMINAL,
    CMD_SRC_SERIAL,
    CMD_SRC_CAN,
    CMD_SRC_INTERNAL
};

#endif