#include "mbed.h"
#include "CommandProcessor.h"
#include "PreferenceWriter.h"
#include "globals.h"

#include "config.h"
#include "config_driving.h"
#include "config_inverter.h"
#include "config_logging.h"
#include "config_loop.h"
#include "config_motor.h"
#include "config_pins.h"
#include "config_table.h"

void cmd_ls(Serial *pc) {
    DPRINT(TORQUE_MODE);
    FPRINT(MAX_TQPCT_PLUS);
    FPRINT(MAX_TQPCT_MINUS);
    FPRINT(TORQUE_MAX);
    FPRINT(W_MAX);
    FPRINT(BUS_VOLTAGE);
    FPRINT(F_SW);
    FPRINT(K_LOOP_D);
    FPRINT(KI_BASE_D);
    FPRINT(K_LOOP_Q);
    FPRINT(KI_BASE_Q);
    FPRINT(F_SLOW_LOOP);
    FPRINT(INTEGRAL_MAX);
    FPRINT(W_FILTER_STRENGTH);
    FPRINT(DQ_FILTER_STRENGTH);
    FPRINT(THROTTLE_FILTER_STRENGTH);
    FPRINT(KP_D);
    FPRINT(KI_D);
    FPRINT(KP_Q);
    FPRINT(KI_Q);
    FPRINT(SLOW_LOOP_COUNTER);
    FPRINT(POLE_PAIRS);
    FPRINT(POS_OFFSET);
    FPRINT(RESOLVER_LOBES);
    DPRINT(CPR);
    FPRINT(Ld);
    FPRINT(Lq);
    FPRINT(FLUX_LINKAGE);
    FPRINT(Rs);
    FPRINT(KT);
    FPRINT(W_SAFE);
    FPRINT(W_CRAZY);
    DPRINT(TH_LIMIT_LOW);
    DPRINT(TH_LIMIT_HIGH);
    DPRINT(TH_LIMIT_CRAZY);
    DPRINT(ROWS);
    DPRINT(COLUMNS);
    FPRINT(W_STEP);
}

void cmd_ls2(Serial *pc, char *buf) {
    if (strcmp(buf, "mode") == 0) {
        pc->printf("%s\n", mode_to_str(BREMS_mode));
        return;
    }
    if (strcmp(buf, "src") == 0) {
        pc->printf("%s\n", src_to_str(BREMS_src));
        return;
    }
    if (strcmp(buf, "op") == 0) {
        pc->printf("%s\n", op_to_str(BREMS_op));
        return;
    }
    
    float *fptr = checkf(buf);
    if (fptr != NULL) pc->printf("%s: %f\n", buf, *fptr);
    int *nptr = NULL;
    if (fptr == NULL) nptr = checkn(buf);
    if (nptr != NULL) pc->printf("%s: %d\n", buf, *nptr);
    if (nptr == NULL && fptr == NULL) pc->printf("%s\n", "No Such Parameter");
}

void cmd_defaults(Serial *pc) {
    DEFAULT(TORQUE_MODE);
    DEFAULT(MAX_TQPCT_PLUS);
    DEFAULT(MAX_TQPCT_MINUS);
    DEFAULT(TORQUE_MAX);
    DEFAULT(W_MAX);
    DEFAULT(BUS_VOLTAGE);
    DEFAULT(F_SW);
    DEFAULT(K_LOOP_D);
    DEFAULT(KI_BASE_D);
    DEFAULT(K_LOOP_Q);
    DEFAULT(KI_BASE_Q);
    DEFAULT(F_SLOW_LOOP);
    DEFAULT(INTEGRAL_MAX);
    DEFAULT(W_FILTER_STRENGTH);
    DEFAULT(DQ_FILTER_STRENGTH);
    DEFAULT(THROTTLE_FILTER_STRENGTH);
    DEFAULT(KP_D);
    DEFAULT(KI_D);
    DEFAULT(KP_Q);
    DEFAULT(KI_Q);
    DEFAULT(SLOW_LOOP_COUNTER);
    DEFAULT(POLE_PAIRS);
    DEFAULT(POS_OFFSET);
    DEFAULT(RESOLVER_LOBES);
    DEFAULT(CPR);
    DEFAULT(Ld);
    DEFAULT(Lq);
    DEFAULT(FLUX_LINKAGE);
    DEFAULT(Rs);
    DEFAULT(KT);
    DEFAULT(W_SAFE);
    DEFAULT(W_CRAZY);
    DEFAULT(TH_LIMIT_LOW);
    DEFAULT(TH_LIMIT_HIGH);
    DEFAULT(TH_LIMIT_CRAZY);
    DEFAULT(ROWS);
    DEFAULT(COLUMNS);
    DEFAULT(W_STEP);
    pc->printf("Defaults Loaded\n");
}

void cmd_reload(Serial *pc, PreferenceWriter *pref) {
    pref->load();
    pc->printf("Flash Values Loaded\n");
}

void cmd_set(Serial *pc, char *buf, char *val) {
    float *fptr = checkf(buf);
    if (fptr != NULL) *fptr = (float) (atof(val));
    int *nptr = NULL;
    if (fptr == NULL) nptr = checkn(buf);
    if (nptr != NULL) *nptr = (int) (atoi(val));
    cmd_ls2(pc, buf);
    if (nptr == NULL && fptr == NULL) pc->printf("%s\n", "No Such Parameter");
}

void cmd_flush(Serial *pc, PreferenceWriter *pref) {
    if (!pref->ready()) pref->open();
    pref->flush();
}