#ifndef __GLOBALS_H
#define __GLOBALS_H

#include "FastPWM.h"
#include "PreferenceWriter.h"

extern FastPWM *out1, *out2, *out3;
extern int adval1, adval2;
extern PreferenceWriter *pref;
extern float current, throttle, vout, user_cmd;

extern int __int_reg[];
extern float __float_reg[];

#define I_LIMIT __float_reg[0]
#define KP __float_reg[1]
#define KI __float_reg[2]
#define F_SW __float_reg[3]
#define THROTTLE_DEADBAND __float_reg[4]
#define ANALOG_THROTTLE_LOW __float_reg[5]
#define ANALOG_THROTTLE_HI __float_reg[6]

#define PREFS_VALID __int_reg[0]
#define BREMS_src __int_reg[1]
#define BREMS_op __int_reg[2]

#define NUM_OPS 4
enum {
    OP_TORQUE,
    OP_DRIVING,
    OP_SPEED,
    OP_POSITION,
};

#define NUM_SRCS 6
enum {
    CMD_SRC_RC,
    CMD_SRC_ANALOG,
    CMD_SRC_TERMINAL,
    CMD_SRC_SERIAL,
    CMD_SRC_CAN,
    CMD_SRC_INTERNAL
};

#define set_dtc(a, x) *a = (x)

#endif