#include "mbed.h"
#include "CommandProcessor.h"

#include "globals.h"

int tokenize(char *buf, char **out, int max) {
    char* tok;
    int k = 0;
    
    tok = strtok(buf, " ");
    
    while(tok != NULL && k < max) {
        out[k] = tok;
        k++;
        tok = strtok(NULL, " ");
    }
    return k;
}

#define __check(x) if(strcmp(s, #x) == 0) return &x

float* checkf(char *s) {
    __check(KP);
    __check(KI);
    __check(I_LIMIT);
    __check(F_SW);
    __check(THROTTLE_DEADBAND);
    __check(ANALOG_THROTTLE_LOW);
    __check(ANALOG_THROTTLE_HI);
    return NULL;
}

int* checkn(char *s) {
    return NULL;
}

#define __strcase(in, out) case in:strcpy(result, out);break
#define __intcase(in, out) if (strcmp(buf, in) == 0) return out

char* src_to_str(int n) {
    static char result[12];
    switch (n) {
        __strcase(CMD_SRC_RC, "RC");
        __strcase(CMD_SRC_ANALOG, "Analog");
        __strcase(CMD_SRC_TERMINAL, "Terminal");
        __strcase(CMD_SRC_SERIAL, "Serial");
        __strcase(CMD_SRC_CAN, "CAN");
        __strcase(CMD_SRC_INTERNAL, "Internal");
    default:
        strcpy(result, "Invalid");
        break;
    }
    return result;
}

int str_to_src(char *buf) {
    __intcase("rc", CMD_SRC_RC);
    __intcase("analog", CMD_SRC_ANALOG);
    __intcase("terminal", CMD_SRC_TERMINAL);
    __intcase("serial", CMD_SRC_SERIAL);
    __intcase("can", CMD_SRC_CAN);
    __intcase("internal", CMD_SRC_INTERNAL);
    return -1;
}


char* op_to_str(int n) {
    static char result[24];
    switch(n) {
        __strcase(OP_TORQUE, "Torque loop");
        __strcase(OP_DRIVING, "Driving map");
        __strcase(OP_SPEED, "Open-loop speed");
        __strcase(OP_POSITION, "Position loop");
    default:
        strcpy(result, "Invalid");
        break;
    }
    return result;
}

int str_to_op(char *buf) {
    __intcase("torque", OP_TORQUE);
    __intcase("driving", OP_DRIVING);
    __intcase("speed", OP_SPEED);
    __intcase("pos", OP_POSITION);
    __intcase("position", OP_POSITION);
    return -1;
}    