#ifndef __COMMAND_PROCESSOR_H
#define __COMMAND_PROCESSOR_H

#include "mbed.h"
#include "PreferenceWriter.h"

void processCmd(Serial *pc, char *buf);

/*---mode switching---*/
void cmd_setp(Serial *pc, char *buf);
void cmd_freq(Serial *pc, char *buf);
void cmd_src(Serial *pc, char *buf);
void cmd_op(Serial *pc, char *buf);
void cmd_ls(Serial *pc);

/*---setting/getting parameters---*/
void cmd_ls2(Serial *pc, char *buf);
void cmd_set(Serial *pc, char *buf, char *val);
void cmd_flush(Serial *pc, PreferenceWriter *pref);
void cmd_reload(Serial *pc, PreferenceWriter *pref);
void cmd_query(Serial *pc, char *buf);

/*---system commands---*/
void cmd_clear(Serial *pc);
void cmd_help(Serial *pc);

/*---internal functions---*/
int tokenize(char *buf, char **out, int max);
int str_to_src(char *buf);
char* src_to_str(int n);
float* checkf(char *s);
int* checkn(char *s);
char* op_to_str(int n);
int str_to_op(char *buf);

#endif