#include "mbed.h"
#include "CommandProcessor.h"
#include "globals.h"

void processCmd(Serial *pc,char *buf) {
    char *tokens[10];
    int len = tokenize(buf, tokens, 10);
    
    switch (len) {
    case 1:
        if (strcmp(tokens[0], "clear") == 0) cmd_clear(pc);
        else if (strcmp(tokens[0], "help") == 0) cmd_help(pc);
        else if (strcmp(tokens[0], "reload") == 0) cmd_reload(pc, pref);
        else if (strcmp(tokens[0], "load") == 0) cmd_reload(pc, pref);
        else if (strcmp(tokens[0], "flush") == 0) cmd_flush(pc, pref);
        else if (strcmp(tokens[0], "src") == 0) cmd_ls2(pc, tokens[0]);
        else if (strcmp(tokens[0], "op") == 0) cmd_ls2(pc, tokens[0]);
        else if (strcmp(tokens[0], "ls") == 0) cmd_ls(pc);
        else pc->printf("%s\n", "Bad command");
        break;
    case 2:
        if (strcmp(tokens[0], "setp") == 0) cmd_setp(pc, tokens[1]);
        else if (strcmp(tokens[0], "freq") == 0) cmd_freq(pc, tokens[1]);
        else if (strcmp(tokens[0], "ls") == 0) cmd_ls2(pc, tokens[1]);
        else if (strcmp(tokens[0], "src") == 0) cmd_src(pc, tokens[1]);
        else if (strcmp(tokens[0], "op") == 0) cmd_op(pc, tokens[1]);
        else if (strcmp(tokens[0], "query") == 0) cmd_query(pc, tokens[1]);
        else pc->printf("%s\n", "Bad command");
        break;
    case 3:
        if (strcmp(tokens[0], "set") == 0) cmd_set(pc, tokens[1], tokens[2]);
        break;
    default:
        pc->printf("%s\n", "Bad command");
        break;
    }
}