#include "mbed.h"
#include "CommandProcessor.h"
#include "globals.h"

#define FPRINT(a) pc->printf("%s: %f\n", #a, a)
#define DPRINT(a) pc->printf("%s: %d\n", #a, a)

void cmd_ls(Serial *pc) {
    DPRINT(PREFS_VALID);
    FPRINT(I_LIMIT);
    FPRINT(KP);
    FPRINT(KI);
    FPRINT(F_SW);
    FPRINT(THROTTLE_DEADBAND);
    FPRINT(ANALOG_THROTTLE_LOW);
    FPRINT(ANALOG_THROTTLE_HI);
}

void cmd_ls2(Serial *pc, char *buf) {    
    if (strcmp(buf, "src") == 0) {
        pc->printf("%s\n", src_to_str(BREMS_src));
        return;
    }
    if (strcmp(buf, "op") == 0) {
        pc->printf("%s\n", op_to_str(BREMS_op));
        return;
    }
    
    float *fptr = checkf(buf);
    if (fptr != NULL) pc->printf("%s: %f\n", buf, *fptr);
    int *nptr = NULL;
    if (fptr == NULL) nptr = checkn(buf);
    if (nptr != NULL) pc->printf("%s: %d\n", buf, *nptr);
    if (nptr == NULL && fptr == NULL) pc->printf("%s\n", "No Such Parameter");
}

void cmd_set(Serial *pc, char *buf, char *val) {
    float *fptr = checkf(buf);
    if (fptr != NULL) *fptr = (float) (atof(val));
    int *nptr = NULL;
    if (fptr == NULL) nptr = checkn(buf);
    if (nptr != NULL) *nptr = (int) (atoi(val));
    if (nptr != NULL || fptr != NULL) cmd_ls2(pc, buf);
    if (nptr == NULL && fptr == NULL) pc->printf("%s\n", "No Such Parameter");
}

void cmd_flush(Serial *pc, PreferenceWriter *pref) {
    if (!pref->ready()) pref->open();
    PREFS_VALID = 1;
    pref->flush();
}

void cmd_reload(Serial *pc, PreferenceWriter *pref) {
    pref->load();
    if (PREFS_VALID) pc->printf("Flash Values Loaded\n");
}

void cmd_query(Serial *pc, char *buf) {
    if (strcmp(buf, "i") == 0) pc->printf("%f\n", current);
    else if (strcmp(buf, "cmd") == 0) pc->printf("%f\n", throttle);
    else if (strcmp(buf, "v") == 0) pc->printf("%f\n", vout);
    else pc->printf("%s\n", "No such parameter");
}