#include "mbed.h"
#include "CommandProcessor.h"

#include "globals.h"

void cmd_setp(Serial *pc, char *buf) {
    float dtc = atof(buf);
    if (dtc < 0.0f) dtc = 0.0f;
    if (dtc > 1.0f) dtc = 1.0f;
    user_cmd = dtc;
}

void cmd_freq(Serial *pc, char *buf) {
    float freq = atof(buf);
    if (freq < 500.0f) freq = 500.0f;
    if (freq > 10000.0f) freq = 10000.0f;
    TIM1->ARR = (int) ((float) 9e7 / freq);
}

void cmd_src(Serial *pc, char *buf) {
    int n = str_to_src(buf);
    if (n < 0) {
        pc->printf("%s\n", "Invalid Source");
        return;
    }
    BREMS_src = n;
    pc->printf("Set source to %s\n", src_to_str(n));
}

void cmd_op(Serial *pc, char *buf) {
    int n = str_to_op(buf);
    if (n < 0) {
        pc->printf("%s\n", "Invalid operation");
        return;
    }
    BREMS_op = n;
    pc->printf("Set operation to %s\n", op_to_str(n));
}
    