#include "includes.h"
#include "sensors.h"

Throttle::Throttle(PinName pin, float min, float max) {
    _in = new AnalogVoltageSensor(pin, 1.0f);
    _min = min;
    _max = max;
}

float Throttle::GetThrottle() {
    float v = _in->GetVoltage();
    return (v - _min) / (_max - _min);
}