#include "includes.h"
#include "core.h"
#include "sensors.h"
#include "meta.h"

unsigned long StatusUpdater::_time;

StatusUpdater::StatusUpdater(Inverter *inverter, Motor *motor, User *user) {
    _inverter = inverter;
    _motor = _motor;
    _user = user;
    _fast_sample_rate = 5000;
    _slow_sample_rate = 10;
    
    _time_ticker.attach_us(&time_upd_isr, 50);
}

void StatusUpdater::Config(int fast_sample_rate, int slow_sample_rate) {
    _fast_sample_rate = fast_sample_rate;
    _slow_sample_rate = slow_sample_rate;
}

void StatusUpdater::time_upd_isr() {
    _time++;
}

void StatusUpdater::Start() {
    _time = 0;
    int fast_us = 1000000 / _fast_sample_rate;
    int slow_us = 1000000 / _slow_sample_rate;
    
    int last_fast = 0;
    int last_slow = 0;
    
    for (;;) {
        if (_time - last_fast > fast_us) {
            _motor->UpdateState();
            _inverter->UpdateVbus();
            last_fast = _time;
        }
        if (_time - last_slow > slow_us) {
            _user->UpdateState();
            _motor->UpdateTemp();
            _inverter->UpdateTemp();
            last_slow = _time;
        }
    }
}