#include "includes.h"
#include "core.h"
#include "sensors.h"

Motor::Motor(CurrentSensor *sense_a, CurrentSensor *sense_b, PositionSensor *sense_p, TempSensor *sense_t) {
    _sense_a = sense_a;
    _sense_b = sense_b;
    _sense_p = sense_p;
    _sense_t = sense_t;
    UpdateState();
}

float Motor::UpdateCurrentA() {
    return I_a = _sense_a->GetCurrent();
}

float Motor::UpdateCurrentB() {
    return I_b = _sense_b->GetCurrent();
}

float Motor::UpdatePosition() {
    return angle = _sense_p->GetPosition();
}

float Motor::UpdateTemp() {
    return temp = _sense_t->GetTemp();
}

void Motor::UpdateState() {
    UpdateCurrentA();
    UpdateCurrentB();
    UpdatePosition();
}

void Motor::Config(int num_poles, float kv) {
    _num_poles = num_poles;
    _kv = kv;
}