#include "includes.h"
#include "core.h"
#include "sensors.h"
#include "meta.h"

int main() {
    PositionSensor *sense_p = new AnalogHallPositionSensor(A4, A5, 0.256f, 0.484f, 0.254f, 0.474f, 205.0f);
    CurrentSensor *sense_ia = new AnalogCurrentSensor(A1, 0.01);
    CurrentSensor *sense_ib = new AnalogCurrentSensor(A2, 0.01);
    VoltageSensor *sense_bus = new AnalogVoltageSensor(A5, 0.01);
    TempSensor *sense_t_motor = new TempSensor();
    TempSensor *sense_t_inverter = new TempSensor();
    Throttle *throttle = new Throttle(A0, 0.5f, 3.0f);
    
    PidController *pid_d = new PidController(1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    PidController *pid_q = new PidController (1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    
    Motor *motor = new Motor(sense_ia, sense_ib, sense_p, sense_t_motor);
    Inverter *inverter = new Inverter(D6, D13, D3, D8, sense_bus, sense_t_inverter);
    User *user = new User(throttle);
    Modulator *modulator = new SinusoidalModulator(inverter);
    StatusUpdater *updater = new StatusUpdater(inverter, motor, user);
    LoopDriver *driver = new LoopDriver(inverter, motor, user, pid_d, pid_q, modulator, 100.0f, 5000);
    
    motor->Config(4, 20.0f);
    updater->Config(5000, 10);
    
    driver->Start();
    updater->Start();
}
