#include "includes.h"
#include "sensors.h"

AnalogCurrentSensor::AnalogCurrentSensor(PinName pin, float volts_per_amp) {
    _in = new AnalogIn(pin);
    _volts_per_amp = volts_per_amp;
    Zero();
}

void AnalogCurrentSensor::Zero() {
    _zero_level = (float) *_in;
}

float AnalogCurrentSensor::GetCurrent() {
    return ((float) *_in - _zero_level) * 3.3f / _volts_per_amp;
}