#include "mbed.h"


#include "constants.h"
#include "shared.h"
#include "util.h"
#include "math.h"
#include "isr.h"

Serial pc(SERIAL_TX, SERIAL_RX);

PwmOut pha(_PH_A);
PwmOut phb(_PH_B);
PwmOut phc(_PH_C);

DigitalOut en(_EN);

DigitalIn dummy(D5);

AnalogIn throttle(_THROTTLE);
AnalogIn analoga(_ANALOGA);
AnalogIn analogb(_ANALOGB);

Motor* motor;

#ifdef __DEBUG
float *fbuffer;
int bufidx = 0;
int skipidx = 0;
#endif
#ifdef __USE_THROTTLE
    Ticker dtc_upd_ticker;
    Ticker throttle_upd_ticker;
#endif

float throttle_read;

int main() {
#ifdef __DEBUG
    pc.printf("%s\n", "Debug mode ON");
#endif
    en = 1;
#ifdef __DEBUG
    fbuffer = (float*)malloc(DBG_BUF_SZ*sizeof(float));
#endif
    initTimers();
    initPins();
    initData();
    
    while(1) {
#ifdef __USE_THROTTLE
        throttle_read = throttle;
#endif
        pos_update();
#ifndef __USE_THROTTLE
        dtc_update();
#endif
#ifdef __DEBUG
        if (motor->debug_stop) break;
#endif
    }
#ifdef __DEBUG
    for (int i = 0; i < DBG_BUF_SZ; i++) {
        pc.printf("%f,", fbuffer[i]);
    }
#endif
}
