#include "mbed.h"

#define PAGE_SIZE 4096
#define HEADER_SIZE 10
#define PACKET_SIZE 8
#define BAUD_RATE 921600
#define F_SW 5000.0f

#define clip(a) if ((a > 254)) a = 254

Serial serial4(A0, A1);
Ticker tick;
DigitalOut test(PC_8);
DigitalOut test2(PC_6);
DigitalOut led(LED1);

int index = 0;
char *front, *back, *tmp;
char buf1[PAGE_SIZE], buf2[PAGE_SIZE];

unsigned char a = 0, b = 32, c = 64, d = 96, e = 128, f = 160, g = 192, h = 224;
void tic() {
    test = 1;
    volatile int x;
    for (x = 0; x < 1000; x++) {
    }
    front[index] = 0xff;
    front[index+1] = a++;
    front[index+2] = b++;
    front[index+3] = c++;
    front[index+4] = d++;
    front[index+5] = e++;
    front[index+6] = f++;
    front[index+7] = g++;
    front[index+8] = h++;
    if (a == 0xff) a = 0;
    if (b == 0xff) b = 0;
    if (c == 0xff) c = 0;
    if (d == 0xff) d = 0;
    if (e == 0xff) e = 0;
    if (f == 0xff) f = 0;
    if (g == 0xff) g = 0;
    if (h == 0xff) h = 0;  
    index += PACKET_SIZE+1;
    test = 0;
}

int main() {
    front = buf1;
    back = buf2;
    
    serial4.baud(BAUD_RATE);
    tick.attach(tic, 1/F_SW);
    
    for (;;) {
        if (index == PAGE_SIZE-HEADER_SIZE) {
            test2 = 1;
            led = 1;
            index = 0;
            tmp = front;
            front = back;
            back = tmp;
            for (int i = 0; i < PAGE_SIZE-HEADER_SIZE; i++) serial4.putc(back[i]);
            led = 0;
            test2 = 0;
        }
    }
}
