#include "mbed.h"

#include "SoftPWM.h"

//SPI spi(p23, p24, p25); // mosi, miso, sclk
//DigitalOut cs(p22);

AnalogIn   ain(A5);

#define RESISTOR 46500

/*
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);*/

SoftPWM  led1(LED1);
SoftPWM  led2(LED2);
SoftPWM  led3(LED3);
SoftPWM  led4(LED4);

//DigitalOut output(D11);
DigitalOut muxPower(D12);

DigitalOut mux0(D2);
DigitalOut mux1(D1);
DigitalOut mux2(D0);

DigitalOut colS0(D3);
DigitalOut colS1(D4);
DigitalOut colS2(D5);

DigitalOut colB0(D10);
DigitalOut colB1(D11);


//Seat Row 1,2,3: Grey, White Pink
//Seat Col 1,2,3: Yellow, Purple, Blue

//Back Row 1,2: Green, Red
//Back Col 1,2: Pink, Black

//Seat: 3x3 matrix of square sensors
//Back: 2x2 matrix, row 1 (bottom) is 2 square, row 2 (top) is 2 circular

//Mux: rowS1, rowS2, rowS3, rowB1, rowB2

float seatrowreadings[3][3];
float seatrowsum[3];

float backrowreadings[2][2];
float backrowsum[2];

int seatdata[3][3];
int backdata[2][2];

Serial pc(USBTX, USBRX);

// main() runs in its own thread in the OS
void muxSelect(int input){
    mux0=input%2;
    mux1=((int)(input/2))%2;
    mux2=((int)(input/4))%2;
    }
    
void seatColSelect(int input){
    if(input==0){
        colS0=1;
        colS1=0;
        colS2=0;
        }
            if(input==1){
        colS0=0;
        colS1=1;
        colS2=0;
        }
            if(input==2){
        colS0=0;
        colS1=0;
        colS2=1;
        }
        
}


void backColSelect(int input){
    if(input==0){
        colB0=1;
        colB1=0;
        }
            if(input==1){
        colB0=0;
        colB1=1;
        }
        
}

int main()
{
    led1.period_ms( 1 ); //set up pwm
    led2.period_ms( 1 );
    led3.period_ms( 1 );
    led4.period_ms( 1 );
    pc.baud (115200);

    //cs = 1;// Chip must be deselected

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    //spi.format(8,3);
    //spi.frequency(1000000);

    /*cs = 0;// Select the device by seting chip select low
    spi.write(0x0A); //write mode
    spi.write(0x2D); // power register
    spi.write(0x02); //enable measurement mode
    cs = 1;// Deselect the device
    */
    //__disable_irq(); //the tick(?) runs every 1ms, and halts everything for 50uS!
    
    muxPower=1;
    while(1) {

        //wait(0.5);
        /*cs = 0;// Select the device by seting chip select low
        spi.write(0x0B); //read mode
        spi.write(0x08);     // X axis
        int xacc=spi.write(0x00); //dummy byte to get data
        cs = 1;// Deselect the device

        cs = 0;// Select the device by seting chip select low
        spi.write(0x0B); //read mode
        spi.write(0x09);     // Y axis
        int yacc=spi.write(0x00); //dummy byte to get data
        cs = 1;// Deselect the device

        cs = 0;// Select the device by seting chip select low
        spi.write(0x0B); //read mode
        spi.write(0x0A);     // Z axis
        int zacc=spi.write(0x00); //dummy byte to get data
        cs = 1;// Deselect the device

        */
        //printf("X = 0x%X\n, Y = 0x%X\n, Z = 0x%X\n, ", xacc,yacc,zacc);

        /*mux0=0;
        mux1=0;
        mux2=0; //select Y0*/
        muxSelect(0);
        seatColSelect(0);
        /*col0=1;
        col1=0; //select col 0*/

        seatrowreadings[0][0]=ain;

        /*col0=0;
        col1=1; //select col 1*/
        seatColSelect(1);
        seatrowreadings[0][1]=ain;
        
        seatColSelect(2);
        seatrowreadings[0][2]=ain;
        
        seatrowsum[0]=0.0f;
        for(int i=0; i<3; i++) {
            seatrowsum[0]+=seatrowreadings[0][i];
        }

        for(int i=0; i<3; i++) {
            seatdata[0][i]=(1-seatrowsum[0])*RESISTOR/seatrowreadings[0][i];
        }
        
        muxSelect(1);
        /*mux0=1;
        mux1=0;
        mux2=0; //select Y0*/

        seatColSelect(0);
        /*col0=1;
        col1=0; //select col 0*/

        seatrowreadings[1][0]=ain;
    /*
        col0=0;
        col1=1; //select col 1*/
        
        seatColSelect(1);
        seatrowreadings[1][1]=ain;
        
        seatColSelect(2);
        seatrowreadings[1][2]=ain;
        
        seatrowsum[1]=0.0f;
        for(int i=0; i<3; i++) {
            seatrowsum[1]+=seatrowreadings[1][i];
        }

        for(int i=0; i<3; i++) {
            seatdata[1][i]=(1-seatrowsum[1])*RESISTOR/seatrowreadings[1][i];
        }


        muxSelect(2);
        
        seatColSelect(0);
        seatrowreadings[2][0]=ain;

        seatColSelect(1);
        seatrowreadings[2][1]=ain;
        
        seatColSelect(2);
        seatrowreadings[2][2]=ain;
        
        seatrowsum[2]=0.0f;
        for(int i=0; i<3; i++) {
            seatrowsum[2]+=seatrowreadings[2][i];
        }

        for(int i=0; i<3; i++) {
            seatdata[2][i]=(1-seatrowsum[2])*RESISTOR/seatrowreadings[2][i];
        }

    //seat only //pc.printf("%i,%i,%i,%i,%i,%i,%i,%i,%i\n", seatdata[0][0], seatdata[0][1], seatdata[0][2], seatdata[1][0], seatdata[1][1], seatdata[1][2], seatdata[2][0], seatdata[2][1], seatdata[2][2]);
    //formatted seat //pc.printf("%i,%i,%i \n%i,%i,%i \n%i,%i,%i\n\n", seatdata[0][0], seatdata[0][1], seatdata[0][2], seatdata[1][0], seatdata[1][1], seatdata[1][2], seatdata[2][0], seatdata[2][1], seatdata[2][2]);
    
    
    
    
    muxSelect(3);
        
        backColSelect(0);
        backrowreadings[0][0]=ain;

        backColSelect(1);
        backrowreadings[0][1]=ain;
        
        backrowsum[0]=0.0f;
        for(int i=0; i<2; i++) {
            backrowsum[0]+=backrowreadings[0][i];
        }

        for(int i=0; i<2; i++) {
            backdata[0][i]=(1-backrowsum[0])*RESISTOR/backrowreadings[0][i];
        }


muxSelect(4);
        
        backColSelect(0);
        backrowreadings[1][0]=ain;

        backColSelect(1);
        backrowreadings[1][1]=ain;
        
        backrowsum[1]=0.0f;
        for(int i=0; i<2; i++) {
            backrowsum[1]+=backrowreadings[1][i];
        }

        for(int i=0; i<2; i++) {
            backdata[1][i]=(1-backrowsum[1])*RESISTOR/backrowreadings[1][i];
        }
        
  //formatted back //pc.printf("%i,%i \n%i,%i \n\n", backdata[0][0], backdata[0][1], backdata[1][0], backdata[1][1]);
  
  //formatted Full //pc.printf("%i,%i \n%i,%i \n\n %i,%i,%i \n%i,%i,%i \n%i,%i,%i\n\n\n", backdata[0][0], backdata[0][1], backdata[1][0], backdata[1][1], seatdata[0][0], seatdata[0][1], seatdata[0][2], seatdata[1][0], seatdata[1][1], seatdata[1][2], seatdata[2][0], seatdata[2][1], seatdata[2][2]);
   pc.printf("%i,%i,%i,%i,%i,%i,%i,%i,%i,%i,%i,%i,%i\n", backdata[0][0], backdata[0][1], backdata[1][0], backdata[1][1], seatdata[0][0], seatdata[0][1], seatdata[0][2], seatdata[1][0], seatdata[1][1], seatdata[1][2], seatdata[2][0], seatdata[2][1], seatdata[2][2]);
 
        /*led1=1.0f-((8000.0f-sensordata[0][0])/500.0f)*((8000.0f-sensordata[0][0])/500.0f)*((8000.0f-sensordata[0][0])/500.0f)/5000.0f;
        led2=1.0f-((8000.0f-sensordata[1][0])/500.0f)*((8000.0f-sensordata[1][0])/500.0f)*((8000.0f-sensordata[1][0])/500.0f)/5000.0f;
        led3=1.0f-((8000.0f-sensordata[0][1])/500.0f)*((8000.0f-sensordata[0][1])/500.0f)*((8000.0f-sensordata[0][1])/500.0f)/5000.0f;
        led4=1.0f-((8000.0f-sensordata[1][1])/500.0f)*((8000.0f-sensordata[1][1])/500.0f)*((8000.0f-sensordata[1][1])/500.0f)/5000.0f;
        */
    //wait(0.5);
    }
}

