#include "mbed.h"

#include "SoftPWM.h"

SPI spi(p23, p24, p25); // mosi, miso, sclk
DigitalOut cs(p22);

AnalogIn   ain(A5);

#define RESISTOR 46500

/*
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);*/

SoftPWM  led1(LED1);
SoftPWM  led2(LED2);
SoftPWM  led3(LED3);
SoftPWM  led4(LED4);

DigitalOut output(D11);

DigitalOut mux0(D2);
DigitalOut mux1(D1);
DigitalOut mux2(D0);

DigitalOut col0(D3);
DigitalOut col1(D4);

float rowreadings[2][2];
float rowsum[2];
int sensordata[2][2];

Serial pc(USBTX, USBRX);

// main() runs in its own thread in the OS
int main()
{
    led1.period_ms( 1 ); //set up pwm
    led2.period_ms( 1 );
    led3.period_ms( 1 );
    led4.period_ms( 1 );
    pc.baud (115200);

    cs = 1;// Chip must be deselected

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(1000000);

    cs = 0;// Select the device by seting chip select low
    spi.write(0x0A); //write mode
    spi.write(0x2D); // power register
    spi.write(0x02); //enable measurement mode
    cs = 1;// Deselect the device

    //__disable_irq(); //the tick(?) runs every 1ms, and halts everything for 50uS!
    while(1) {


        cs = 0;// Select the device by seting chip select low
        spi.write(0x0B); //read mode
        spi.write(0x08);     // X axis
        int xacc=spi.write(0x00); //dummy byte to get data
        cs = 1;// Deselect the device

        cs = 0;// Select the device by seting chip select low
        spi.write(0x0B); //read mode
        spi.write(0x09);     // Y axis
        int yacc=spi.write(0x00); //dummy byte to get data
        cs = 1;// Deselect the device

        cs = 0;// Select the device by seting chip select low
        spi.write(0x0B); //read mode
        spi.write(0x0A);     // Z axis
        int zacc=spi.write(0x00); //dummy byte to get data
        cs = 1;// Deselect the device


        //printf("X = 0x%X\n, Y = 0x%X\n, Z = 0x%X\n, ", xacc,yacc,zacc);

        mux0=0;
        mux1=0;
        mux2=0; //select Y0

        col0=1;
        col1=0; //select col 0

        rowreadings[0][0]=ain;

        col0=0;
        col1=1; //select col 1
        rowreadings[0][1]=ain;
        rowsum[0]=0.0f;
        for(int i=0; i<2; i++) {
            rowsum[0]+=rowreadings[0][i];
        }

        for(int i=0; i<2; i++) {
            sensordata[0][i]=(1-rowsum[0])*RESISTOR/rowreadings[0][i];
        }
        mux0=1;
        mux1=0;
        mux2=0; //select Y0

        col0=1;
        col1=0; //select col 0

        rowreadings[1][0]=ain;

        col0=0;
        col1=1; //select col 1
        rowreadings[1][1]=ain;
        rowsum[1]=0.0f;
        for(int i=0; i<2; i++) {
            rowsum[1]+=rowreadings[1][i];
        }

        for(int i=0; i<2; i++) {
            sensordata[1][i]=(1-rowsum[1])*RESISTOR/rowreadings[1][i];
        }

    pc.printf("%i,%i,%i,%i\n", sensordata[0][0], sensordata[0][1], sensordata[1][0], sensordata[1][1]);
    
    
        led1=1.0f-((8000.0f-sensordata[0][0])/500.0f)*((8000.0f-sensordata[0][0])/500.0f)*((8000.0f-sensordata[0][0])/500.0f)/5000.0f;
        led2=1.0f-((8000.0f-sensordata[1][0])/500.0f)*((8000.0f-sensordata[1][0])/500.0f)*((8000.0f-sensordata[1][0])/500.0f)/5000.0f;
        led3=1.0f-((8000.0f-sensordata[0][1])/500.0f)*((8000.0f-sensordata[0][1])/500.0f)*((8000.0f-sensordata[0][1])/500.0f)/5000.0f;
        led4=1.0f-((8000.0f-sensordata[1][1])/500.0f)*((8000.0f-sensordata[1][1])/500.0f)*((8000.0f-sensordata[1][1])/500.0f)/5000.0f;
    //wait(0.5);
    }
}

