/*******************************************************************************
 * Mangages LCD display, joystick and accelerometer for user interface.
 * Bryan Wade
 * 27 MAR 2014
 ******************************************************************************/
#ifndef USER_INTERFACE_H
#define USER_INTERFACE_H

#include "effects.h"

// Initialize module.
void UI_Initialize(void);

// Update the display and poll all input devices.
void UI_Update(int32_t bufferLevel);

// Get the effect mode selected by joystick.
effect_mode_t UI_GetEffectMode(void);

// Get the effect gain selected by accelerometer tilt.
uint16_t UI_GetEffectGain(void);

#endif