/*******************************************************************************
 * Module processes 16-bit audio samples to produces delay-based sound effects.
 * Bryan Wade
 * 27 MAR 2014
 ******************************************************************************/
#ifndef EFFECTS_H
#define EFFECTS_H

#include <stdint.h>

// Practical gain limit for decent sound.
#define MAX_EFFECT_GAIN (58982) 

// Available sound effect modes
typedef enum effect_mode_t {
    EFFECT_STRAIGHT,
    EFFECT_ECHO,
    EFFECT_REVERB
} effect_mode_t;


// Initialize module.
void Effects_Initialize(void);

// Process one audio sample.
int16_t Effects_ProcessSample(int16_t dataIn);

void Effects_SetMode(effect_mode_t mode);

void Effects_SetGain(uint16_t gain);

#endif