/*******************************************************************************
 * Implements delay lines for audio samples.
 * Bryan Wade
 * 27 MAR 2014
 ******************************************************************************/
#ifndef DELAY_H
#define DELAY_H

#include <stdint.h>
#include <stdlib.h>

typedef struct delay_t delay_t; // Opaque type declaration.

// Get a ptr to a new delay struct
delay_t *Delay_Create(void);

// Configure the delay length and ram location
bool Delay_Configure(delay_t *delay, void *ram, size_t size);

// Write one sample with feedback to the delay and get one sample out.
int16_t Delay_WriteWithFeedback(delay_t *delay, int16_t dataIn, uint16_t gain);

#endif
