/*******************************************************************************
 * Implements FIFO buffer for glitch-free audio playback.
 * Bryan Wade
 * 27 MAR 2014
 ******************************************************************************/
#ifndef BUFFER_H
#define BUFFER_H

#include <stdint.h>
#include <stdlib.h>

typedef struct buffer_t buffer_t; // Opaque type declaration.

// Get a ptr to a new buffer.
buffer_t *Buffer_Create(void *ram, size_t size);

// Read one sample from buffer.
bool Buffer_Read(buffer_t *buffer, int16_t *pDataOut);

// Write one sample to buffer.
void Buffer_Write(buffer_t *buffer, int16_t DataIn);

// Write a block of data to buffer.
void Buffer_WriteBlock(buffer_t *buffer, const int16_t *pDataIn, uint32_t length);

// Get the current number of samples buffered.
int32_t Buffer_GetLevel(buffer_t *buffer);

#endif
