//Including the microbit library
#include "MicroBit.h"

//defining points for the game to set how long runs for 
int points = 0;
//defining co-ordinates for pixels
int obsy = 0;
int x = 4;
int y = 4;
//sets whether game is running or not
bool gamerunning = true;
//users lives before game ends
int lives = 3;

//
MicroBit uBit;
//creates random x co-ordinate
int x2 = uBit.random(5);

//collision test function
void pointscollide() 
{
    //if two x co-ordinates of the bottom pixels are the same 
    if (x == x2)
    {
        /*if points is equal to 8 then this ends the game, 
        sets game running to be false and scrolls across the screen game over 
        you win and then their points */
        if (points == 8)
        {
            gamerunning = false;
            uBit.display.scroll("Game Over, you win");
            uBit.display.scroll(points);
        }
        /* if points isn't 8 then points just adds by 1 then a new pixel is 
        created in a new random location again */
        else
        {
            points = points + 1;
            x2 = uBit.random(5);
            uBit.display.image.setPixelValue(x2, 4, 255);
        }
            
    }
    
            
    
}
//function for button pressing
void onButton(MicroBitEvent e)
{
    //if button A is pressed
    if (e.source == MICROBIT_ID_BUTTON_A) 
    {
        /* shifts over pixel one place to the left whilst 
        getting rid of pixels original place */
        uBit.display.image.setPixelValue(x = x - 1, y, 255);
        if (x < 4)
        {
            uBit.display.image.setPixelValue(x + 1, y, 0);
        }
        //calls collide function to check whether collides with other pixel
        pointscollide();
        
        
    }
    //if button B is pressed
    if (e.source == MICROBIT_ID_BUTTON_B) 
    {
        /* shifts over pixel one place to the right whilst 
        getting rid of pixels original place */
        uBit.display.image.setPixelValue(x = x + 1, y, 255);
        if (x > 0 )
        {
            uBit.display.image.setPixelValue(x - 1, y, 0);
        }
        //calls collide function to check whether collides with other pixel
        pointscollide();
        
        
    }
}




//running game function - for pixels moving down screen
void play()
{
    //creating random x co-ordinate
    int obsx = uBit.random(5);
    /* loop for the size of the y axis on led 
    matrix adding one each time so that the pixel 
    can move down the screen one line at a time */
    for (obsy = 0; obsy  < 5; obsy++){
        /* sets pixels on the screen for each y co-ordinate as it
        increases by 1, sets pixels with x co-ordinates and then 
        deletes pixels above */
        uBit.display.image.setPixelValue(obsx, obsy, 255);
        if (obsx > 0)
        {
            uBit.display.image.setPixelValue(obsx  - 1, obsy, 255);
        }
        if (obsy > 0)
        {
            uBit.display.image.setPixelValue(obsx, obsy - 1, 0);
        }
        if (obsx > 0 && obsy > 0)
        {
            uBit.display.image.setPixelValue(obsx - 1, obsy - 1, 0);
        }
        /* sets the speed depending on the points that 
        the user holds to show the pixels going down each line */
        if (points > 4)
        {
            uBit.sleep(300);
        }
        else if (points > 6)
        {
           uBit.sleep(200);
        } 
        else
        {
           uBit.sleep(600);
        } 
            
            
    }  
        /*tests whether this pixel moving down the screen hits 
        another so it doesn't delete the points receiving pixel  */
        if (obsx == x2 || obsx - 1 == x2)
        {   
           uBit.display.image.setPixelValue(obsx, 4, 255); 
        }
        else
        {
            uBit.display.image.setPixelValue(obsx, 4, 0);
        }
        if (obsx < 4){
            uBit.display.image.setPixelValue(obsx - 1, 4, 0);    
        }
        /* If the pixel hits the pixel manually moved by the 
        buttons then lives will be decreased by 1 but if they're at 0
        then game running set at false and displayed on screen that user 
        loses and displays points */
        if (obsx == x || obsx - 1 == x)
        {
            if (lives == 0)
            {
                gamerunning = false;
                uBit.display.scroll("Game over, you lose");
                uBit.display.scroll(points);
            }
            else
            {
                lives--;
            }
        }
        
    //sets obsy back to 0 so can go through the loop again setting back to start    
    obsy = 0;
    /* recalls the function again to go through the system 
    again with pixel starting at top and moving down again */
    play(); 
}

//Main function
int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();
    //sets two bottom pixels, one to be manually moved by buttons and one for the points system 
    uBit.display.image.setPixelValue(x, y, 255);
    uBit.display.image.setPixelValue(x2, 4, 255);
    //To connect with the buttons so it's acknowledged when one is pressed
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_CLICK, onButton);
    uBit.messageBus.listen(MICROBIT_ID_BUTTON_B, MICROBIT_BUTTON_EVT_CLICK, onButton);
    //plays game when game running set as true but if not displays game over
    if (gamerunning == true)
    {
        play();
    }
    else if (gamerunning == false)
    {
       uBit.display.scroll("Game Over");
       uBit.display.scroll(points);
        
    }
    // If main exits, there may still be other fibers running or 
    // registered event handlers etc.
    // Simply release this fiber, which will mean we enter the 
    // scheduler. Worse case, we then
    // sit in the idle task forever, in a power efficient sleep.    
    release_fiber();
}
