//including library
#include "MicroBit.h"


MicroBit uBit;

bool BP = false;

//defining times for button pressing
uint64_t readtime, timepressed;


//state of when code is running and not
bool mcode = true;

//button function for seeing whether dot or dash
void button()
{
    while(BP == true)
    {
        P0.setDigitalValue(1);
        }P0.setDigtalValue(0);
        
    
    //if button was pressed once
    if (timepressed > 10 && timepressed < 500)
    {
        //shows a dot on the screen
        uBit.display.scroll(".");
        //sets digital value as 0
        uBit.io.P0.setDigitalValue(1);
        
    }
    //if button is held down for a brief amount of time
    else if (timepressed > 500 && timepressed < 1000)
    {
        //shows a dash on screen
        uBit.display.scroll("-");
        //sets digital value at 1
        uBit.io.P0.setDigitalValue(1);
        
    }
    //if button held down for a longer time
    else if (timepressed > 1500)
    {
        //displays stop along the screen
        uBit.display.scroll("STOP");
        //sets mcode as false so buttons stop running
        mcode = false;
        
    }

}
 
 
//button event from message bus for as button is being pressed
void onButton(MicroBitEvent e)
{
    //if mcode is true signals program needs to run
    if (mcode == true)
    {
    //if button A is pressed
        if (e.source == MICROBIT_ID_BUTTON_A) 
        {
            //calculating reading on button being pressed
            BP = true;
            readtime = system_timer_current_time();
        }
    
    }
}

//button event from message bus for when button being let go of
void offButton(MicroBitEvent e)
{
    //if mcode is true signals program needs to run
    if (mcode == true)
    {
    //if button A is pressed
        if (e.source == MICROBIT_ID_BUTTON_A) 
        {
            //sees how long button pressed for
            timepressed = system_timer_current_time() - readtime;
            //calls button function
            button();
    
    
        }
       
    }
}

//main function
int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();
    
    //if mcode is true signals program needs to run
    if (mcode == true)
    {
        
        //message buses for function onButton and offButton for when button clicked
        uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_DOWN, onButton);
        
        uBit.messageBus.listen(MICROBIT_ID_BUTTON_A, MICROBIT_BUTTON_EVT_UP, offButton);
        
        
        
        
        
        
        
    }
    
    // If main exits, there may still be other fibers running or 
    // registered event handlers etc.
    // Simply release this fiber, which will mean we enter the 
    // scheduler. Worse case, we then
    // sit in the idle task forever, in a power efficient sleep.  
    release_fiber();
}