#include "MicroBit.h"

#include "Display.h"
#include "common.h"



int8_t pixels[] = 
    {4,8,10,12,16,0,4,9,14,19,24,2,7,8,25,0,6,7,8,9,10,12,14,18,-1};
    

int8_t yield() {
    static int8_t column=0;
    int8_t retval = pixels[column++];
    if (retval == -1) {
        column=0;
        return -1;
        }
    return retval-1;
    }


void flag1(int8_t(*yieldF)()) {
    for (int8_t i=0; i < 5; i++) {
        display.setFlag(6*i);
        display.setFlag(4+4*i);
        }
    }

void flag2(int8_t(*yieldF)()) {
    int8_t p;
    while ((p = (yieldF)())!=-1) {
        display.setFlag(p);
        }
    }

void (*flg[])(int8_t(*yieldF)()) = {flag1,flag2};

void example_flag() {
    int8_t i=0;
    while (true) {
        display.clear();
        (flg[i>0 ? 1 : 0])(yield);
        i=(i+1) & 3;
        uBit.sleep(2000);
        }
    }
