#include "MicroBit.h"
#include "MicroBitPin.h"

#include "common.h"


void  example_OLED() {
    oled.init();
    
    oled.puts("*** VOLTMETER ****\n\n");
    char spin[] = "|/-\\";
    uint8_t si=0;
    float oldVoltage=0;
    while(true) {
        uint16_t samples =uBit.io.P0.getAnalogValue();
        
        float voltage = 3.3*samples/1023;
        int8_t dir = voltage - oldVoltage > 0.01 
            ? 1
            : voltage - oldVoltage < -0.01
                ? -1
                : 0;
        if (dir) {
            si = (si+dir) & 3;
            oldVoltage=voltage;
            }
        oled.printf("\r%c %03.2f volt ",spin[si],voltage);
        
        }    
}

 
