#include "MicroBit.h"
#include "Display.h"

Display::Display(MicroBitDisplay & uDpl) : uDisplay(uDpl)  {
    clearStick();
    }

void Display::clear() {
    uDisplay.image.clear();
    clearStick();
    }

void Display::setStick(uint8_t length) {
     curLength = length;
     paintStick(&Display::lessCurLength);
     }   

void Display::setFlag(uint8_t position) {
    showbit = position;
    paintStick(&Display::orPoint);
    }

void Display::toRow(uint8_t rowNr, uint8_t rowContent) {
    this->rowNr=rowNr;
    showbit=rowContent;
    paintStick(&Display::bitplot);
    }

void Display::toRows(uint32_t bits25) {    
    showbit=bits25;
    paintStick(&Display::simplePlot);
    }

void Display::vertDecimal(uint8_t r0,uint8_t r1,uint8_t r2,uint8_t r3,uint8_t r4) {
    vertDecimal(r0,r1,r2,r3,r4,false);
    }

void Display::vertDecimal(uint8_t r0,uint8_t r1,uint8_t r2,uint8_t r3,uint8_t r4, bool b15On) {
    Ledrows lr(r0,r1,r2,r3,r4,b15On);
    showbit = lr.all;
    paintStick(&Display::simplePlot);
    }

void Display::vertClock(uint16_t minuts) {
    uint8_t hours = minuts/60;
    minuts -= 60*hours;
    uint8_t h1 = hours/10;
    uint8_t m1 = minuts/10;
    vertDecimal(minuts-10*m1,m1,16,hours-10*h1,h1,false);
}
    
void Display::vertSecClock(uint32_t seconds) {
    uint8_t hours = seconds/3600;
    uint8_t minuts = (seconds - 3600*hours)/60;
    seconds -= 3600*hours+60*minuts;
    uint8_t m1 = minuts/10;
    int8_t s1 = seconds/10;
    vertDecimal(seconds-10*s1,s1,minuts-10*m1,m1,hours,false);
}
    
// private function 

void Display::paintStick(bool(Display::*getState)(uint8_t)) {
    for (int8_t pos = 0; pos < 25; pos++) {
        bool value = (this->*getState)(pos);
        if (stick[pos] != value) {
            stick[pos] = value;
            uDisplay.image.setPixelValue(
                4 - pos % 5,4 - pos / 5,value ? 1 : 0);
        }
    }
}

void Display::clearStick() {
    for (uint8_t i = 0 ; i < 25; i++)
    stick[i]=false; 
}

bool Display::orPoint(uint8_t stickPos) {    
    return showbit == stickPos ? 1 : stick[stickPos];
    }

bool Display::simplePlot(uint8_t stickPos) {
    return ((1 << stickPos) & showbit) > 0 ? true : false;
    }

bool Display::bitplot(uint8_t stickPos) {
    return stickPos < 5*(rowNr+1) && stickPos >= 5*rowNr  
        ? (((1 << (stickPos-5*rowNr)) & showbit) > 0
            ? true
            : false)
        : stick[stickPos];
    }

bool Display::lessCurLength(uint8_t num) {
    return num < curLength;
    }
    
