#include "MicroBit.h"
#include "MicroBitPin.h"
#include "cppNorm.h"
#include "common.h"


/**
  * conclusion: items incl char and char[] are on stack 4 byte alligned (0,4,8,c)
  * on global data char isn't aligned.
  * int8_t[] seems to 2 aligned, but it would demand a  clean global date area to find out
  * variables are not source code ordered!
  */
void typeSizeAndAlignment() {
#define outputscreeen1
#ifdef outputscreeen1
    double d1;
    int8_t int8[3];
    int16_t int16;
    int32_t int32;
    int32_t i32;
                // ADRESS   bytes in decimal 
                //               
    void                                    *addresses[] = {
     int8       // b8       4         
    ,&int8[3]   // bb       3  
    ,&int16     // bc       4  
    ,&d1        // c0       8         
    ,&int32     // c8       4 
    ,&i32};     // cc         
    char names[][8] = {
         "int8"
        ,"int8[3]"
        ,"int16"
        ,"d1"
        ,"int32"
        ,"i32"
        };
#else
    int   i;
    float f;
    char  ch1;
    char  chre[9];
    char  chr3[3];
    char  chr4[4];
    char  chr2[2];
                // ADRESS   bytes(decimal)
    void                           *addresses[] = {
     chre    //     ac      12
    ,&i      //     b8      4
    ,&f      //     bc      4
    ,&ch1    //     c0      4
    ,chr3    //     c4      4
    ,chr4    //     c8      4
    ,chr2 }; //     cc
    char names[][8] = {
        "chre[9]"
        ,"i"
        ,"f"
        ,"ch1"
        ,"chr3[3]"
        ,"chr4[4]"
        ,"chr2[2]"
        };
    
#endif

    for (int i=0; i < sizeof(addresses)/4; i++)
        oled.printf("%-8s %p\n",names[i],addresses[i]);
}    
struct  {
    const static int isConstStatic=0;
    } HasConstStatic;

int csint;

void isGlobalConstStaticFlashed() {
    static int k=2;
    oled.printf("const static \naddr:%p\n",&csint);
    oled.printf("addr:%p\n",&HasConstStatic.isConstStatic);
    oled.printf("addr:%p\n",&k);
    oled.printf("%d",csint);
}

void  example_peek() {
    oled.init();
    //typeSizeAndAlignment();
    isGlobalConstStaticFlashed();
    release_fiber();
}

 
