#include "MicroBit.h"
#include "MicroBitI2C.h"
#include "MicroBitPin.h"
#include "MicroBitDisplay.h"

#include "OLED.h"
#include "Display.h"
#include "common.h"

enum {
     FRED  =4
    ,FUBAR =3
    ,BAZZ  =2
    ,BAR   =1
    ,FOO   =0  /* row 0 - bottom row */
    };

enum {START=1,STATE_A,STATE_B,STATE_C,STATE_D,STATE_E,STATE_F,RETURNED};

int barcounter=1;

void fred(int state) {
    display.toRow(FRED,state);
    }
    
void fubar(int state) {
    display.toRow(FUBAR,state);
    }

void  bazz(int state) {
    display.toRow(BAZZ,state);
    }

void bar() {
    display.toRow(BAR,barcounter++);
    uBit.sleep(2000);
    }

void foo() {
        display.toRow(FOO,START);
        bar();
        // ...
        for (int i=0; i<3; i++) {
            bar();
            fred(i | 4);
            fubar(i |8 );
            bazz(STATE_F);
        }
        // ...
        display.toRow(FOO,STATE_D);
        uBit.sleep(2000);
        display.toRow(FOO,RETURNED);
    }
    
void example_BinaryRows() { foo(); }     
