#include "MicroBit.h"

#include "cppNorm.h"
#include "OLED.h"
#include "Display.h"

MicroBit uBit;
OLED oled;
Display display(uBit.display); // only ref to uninitialized uBit

void example_OLED();
void example_stick();
void example_BinaryRows();
void example_clock();
void example_secClock();
void example_assert();
void example_flag();
void example_peek();


struct {
    void (*example)(void);
    string name;
    } examples[] = { 
         {example_OLED,"OLED"}
        ,{example_stick,"stick"}
        ,{example_BinaryRows,"binaryRows"}
        ,{example_clock,"clock"} // 17:31
        ,{example_secClock,"sec-clock"} // 17:31:00
        ,{example_assert,"assertion"}
        ,{example_flag,"flag"}
        ,{example_peek,"peek"}
        };

void showExample(string name) {
    for (int8_t i = 0; i < sizeof(examples)/sizeof(examples[0]); i++)
        if (name == examples[i].name) 
            (examples[i].example)();
        
}
/**
  * In absence of terminal or bluetooth command interface, chose an example by hand
  */ 
int main() {
    uBit.init();
    
    // change to try
    showExample("flag");
    uBit.panic(987);
}

