/**
  ******************************************************************************
  * @file    ov7670.h
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    25-June-2015
  * @brief   This file contains all the functions prototypes for the ov7670.c
  *          driver.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __OV7670_H
#define __OV7670_H

#ifdef __cplusplus
 extern "C" {
#endif 

/* Includes ------------------------------------------------------------------*/
#include "../Common/camera.h"
   
/** @addtogroup BSP
  * @{
  */ 

/** @addtogroup Components
  * @{
  */ 
  
/** @addtogroup ov7670
  * @{
  */

/** @defgroup OV7670_Exported_Types
  * @{
  */
     
/**
  * @}
  */ 

/** @defgroup OV7670_Exported_Constants
  * @{
  */

/** 
  * @brief  OV7670 ID  
  */  
#define  OV7670_ID    0x76
/** 
  * @brief  OV7670 Registers  
  */

/* OV7670 Registers definition */
#define OV7670_SENSOR_PIDH              0x0A
#define OV7670_SENSOR_PIDL              0x0B
#define OV7670_SENSOR_COM7              0x12
#define OV7670_SENSOR_TSLB              0x3A
#define OV7670_SENSOR_MTX1              0x4F
#define OV7670_SENSOR_MTX2              0x50
#define OV7670_SENSOR_MTX3              0x51
#define OV7670_SENSOR_MTX4              0x52
#define OV7670_SENSOR_MTX5              0x53
#define OV7670_SENSOR_MTX6              0x54
#define OV7670_SENSOR_BRTN              0x55
#define OV7670_SENSOR_CNST1             0x56
#define OV7670_SENSOR_CNST2             0x57

/** 
 * @brief  OV7670 Features Parameters  
 */
#define OV7670_BRIGHTNESS_LEVEL0        0xB0     /* Brightness level -2         */
#define OV7670_BRIGHTNESS_LEVEL1        0x98     /* Brightness level -1         */
#define OV7670_BRIGHTNESS_LEVEL2        0x00     /* Brightness level 0          */
#define OV7670_BRIGHTNESS_LEVEL3        0x18     /* Brightness level +1         */
#define OV7670_BRIGHTNESS_LEVEL4        0x30     /* Brightness level +2         */

#define OV7670_BLACK_WHITE_BW           0xCC000000000000  /* Black and white effect      */
#define OV7670_BLACK_WHITE_NEGATIVE     0xEC808000008080  /* Negative effect             */
#define OV7670_BLACK_WHITE_BW_NEGATIVE  0xEC000000000000  /* BW and Negative effect      */
#define OV7670_BLACK_WHITE_NORMAL       0xCC808000008080  /* Normal effect               */

#define OV7670_CONTRAST_LEVEL0          0x30     /* Contrast level -2           */
#define OV7670_CONTRAST_LEVEL1          0x38     /* Contrast level -1           */
#define OV7670_CONTRAST_LEVEL2          0x40     /* Contrast level 0            */
#define OV7670_CONTRAST_LEVEL3          0x50     /* Contrast level +1           */
#define OV7670_CONTRAST_LEVEL4          0x60     /* Contrast level +2           */

#define OV7670_COLOR_EFFECT_NONE        0xCC808000008080  /* No color effect             */
#define OV7670_COLOR_EFFECT_ANTIQUE     0xCC000020F00000  /* Antique effect              */
#define OV7670_COLOR_EFFECT_BLUE        0xCC000000000060  /* Blue effect                 */
#define OV7670_COLOR_EFFECT_GREEN       0xCC000000008000  /* Green effect                */
#define OV7670_COLOR_EFFECT_RED         0xCC600000000000  /* Red effect                  */
/**
  * @}
  */
  
/** @defgroup OV7670_Exported_Functions
  * @{
  */ 
void     ov7670_Init(uint16_t DeviceAddr, uint32_t resolution);
void     ov7670_Config(uint16_t DeviceAddr, uint32_t feature, uint32_t value, uint32_t BR_value);
uint16_t ov7670_ReadID(uint16_t DeviceAddr);

void     CAMERA_IO_Init(void);
void     CAMERA_IO_Write(uint8_t addr, uint8_t reg, uint8_t value);
uint8_t  CAMERA_IO_Read(uint8_t addr, uint8_t reg);
void     CAMERA_Delay(uint32_t delay);

/* CAMERA driver structure */
extern CAMERA_DrvTypeDef   ov7670_drv;
/**
  * @}
  */    
#ifdef __cplusplus
}
#endif

#endif /* __OV7670_H */
/**
  * @}
  */ 

/**
  * @}
  */ 

/**
  * @}
  */ 

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
