#include "mbed.h"
#include "rtos.h"
#include "burtdaq.h"
#include <vector>
#include "FastIO.h"
#include <stdio.h>      // printf
#include <string.h>     // strcat
#include <stdlib.h>     // strtol

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX,USBRX);
//Serial xbee(XBEETX,XBEERX);

bool led4_FLAG;

//Queue<uint8_t, 50> queue;

#define kDisplayWidth 32
char* pBinFill(long int x,char *so, char fillChar)
{ // fill in array from right to left
 char s[kDisplayWidth+1];
 int  i=kDisplayWidth;
 s[i--]=0x00;   // terminate string
 do
 { // fill in array from right to left
  s[i--]=(x & 1) ? '1':'0';
  x>>=1;  // shift right 1 bit
 } while( x > 0);
 while(i>=0) s[i--]=fillChar;    // fill with fillChar 
 sprintf(so,"%s",s);
 return so;
}


void bridgeReader(void const *argument) {
    SPI spia(NC, SPIA_MISO, SPIA_CLK);
    spia.format(16);
    spia.frequency(1000000);
    //DigitalOut spia_mosi(SPIA_MOSI);
    FastOut<SPIA_MOSI> spia_mosi;
    
    FastPortOut<Port0, SPIA_CS_PORT_MASK> spiaCSPort;
    //PortOut spiaCSPort(Port0, SPIA_CS_PORT_MASK);
    unsigned int bridgeCSPinMasks[5] = {SPIA_P1_CS_PORT_MASK, SPIA_P2_CS_PORT_MASK, SPIA_P3_CS_PORT_MASK, SPIA_P4_CS_PORT_MASK};
    int deviceCount = 4;
    
    spiaCSPort = SPIA_CS_PORT_MASK;
    
    uint16_t outputs[4] = {0x0f0f, 0xf0f0, 0x0000, 0x0000};
    //bridgeCSPins = 3;
    printf("ENTERING READ LOOP\n");
    while(true) {
        __disable_irq();
        led2 = 1;
        // READ BRIDGES
        spia_mosi = 1;
        int i = 0;      // This constitutes ROUGHLY a 500ns delay
        while(i<10)
        i++;
        for(i=0; i<deviceCount; i++){
            spiaCSPort = ~bridgeCSPinMasks[i];
            outputs[i] = spia.write(0x0);
        }
        spiaCSPort = SPIA_CS_PORT_MASK;
        //spiaCSPort = 1;
        spia_mosi = 0;
        // END READING
        
        printf("%u, %u, %u, %u\n",outputs[0],outputs[1],outputs[2],outputs[3]);
        led2 = 0;
        __enable_irq();
        Thread::wait(5000);
    }
}
void tcReader(void const *argument) {
    SPI spib(SPIB_MOSI, SPIB_MISO, SPIB_CLK);
    spib.format(16);
    spib.frequency(1000000);
    
    DigitalOut spibCSPins[] = {SPIB_P1_CS, SPIB_P2_CS, SPIB_P3_CS};
    spibCSPins[0]=1;
    spibCSPins[1]=1;
    spibCSPins[2]=1;
    
    int numTCs = 3;
    uint32_t rawTcData[3] = {0,0,0};
    uint32_t tcData[3] = {0,0,0};
    uint32_t ambientData[3] = {0,0,0};
    
    float humanTcData[3] = {0,0,0};
    float humanAmbientData[3] = {0,0,0};
    
    uint32_t buffer = 0;
    char so[kDisplayWidth+1];
    while (true) {
        __disable_irq();
        led3 = 1;
        for(int i=0; i<numTCs; i++){
            rawTcData[i] = 0;
            spibCSPins[i] = 0;
            buffer = spib.write(0);
            //printf("%s\n",binary_fmt(buffer,tmp));
            rawTcData[i] = (buffer << 16);
            buffer = spib.write(0);
            rawTcData[i] |= (buffer);
            spibCSPins[i] = 1;
        }
        //printf("%s %s %s\n", byte_to_binary(tcData[0]), byte_to_binary(tcData[1]), byte_to_binary(tcData[2]));
        //printf("Data is: %s %s %s\n",pBinFill(tcData[0], so, '0'), pBinFill(tcData[1], so, '0'), pBinFill(tcData[2], so, '0'));
        
        for(int i=0; i<numTCs; i++){
            tcData[i] = ((rawTcData[i] & 0xFFFC0000) >> 18);
            ambientData[i] = ((rawTcData[i] & 0xFFF0) >> 4);
            humanTcData[i] = (float) tcData[i] * .25;
            humanAmbientData[i] = (float) ambientData[i]*.0625;
            printf("Thermocouple %d ambient: %f, tc:%f\n",i,humanAmbientData[i],humanTcData[i]);
        }
        led3=0;
        __enable_irq();
        Thread::wait(2000);
    }
}


void xbeeISR() {

    NVIC_DisableIRQ(UART0_IRQn);
    led4=!led4;
    uint32_t iir = LPC_UART0->RBR;
    NVIC_EnableIRQ(UART0_IRQn);
    return;
}

void blinkThread(void const *argument)
{
     while(1)
     {
        led1=!led1;
        Thread::wait(500);
     }
     
     
     return;
}
void xbeeTestThread(void const *argument)
{
    pc.attach(&xbeeISR,Serial::RxIrq);
    while(1)
    {
        Thread::wait(500);
    }
    
}
int main() {
 //   Serial pc(USBTX,USBRX);
    led4_FLAG = false;
    pc.printf("Starting reader\n");
     pc.attach(&xbeeISR,Serial::RxIrq);
    //Ticker ticker;
    //ticker.attach(blinkThread,1.0);
  //  Thread bridgeReader1(bridgeReader);
   // Thread tcReader1(tcReader);
    //Thread actuatorController1(actuatorController);
    //Thread xbeeTest(xbeeTestThread);
    //xbee.baud(115200);
    Thread blinkTest(blinkThread);
    //Thread xbeeTest(xbeeTestThread);
    
   // xbee.printf("test");
   
    Thread::wait(osWaitForever);
    pc.printf("exiting\n");
}
