//Base Unit containing the accelerometer and the Xbee Module
#include "mbed.h"
 #include "ADXL345.h"
 
 ADXL345 accelerometer(p5, p6, p7, p8);
 Serial pc(USBTX, USBRX);
 
Serial xbee1(p9, p10);
DigitalOut rst1(p11);


DigitalOut myled(LED3);//Create variable for Led 3 on the mbed

int main() {

    // reset the xbees (at least 200ns)
    rst1 = 0;
   // rst2 = 0;
    wait_ms(1); 
    rst1 = 1;
  //  rst2 = 1;
    wait_ms(1); 
    
     int readings[3] = {0, 0, 0};
     
     pc.printf("Starting ADXL345 test...\n");
     pc.printf("Device ID is: 0x%02x\n", accelerometer.getDevId());
 
     //Go into standby mode to configure the device.
     accelerometer.setPowerControl(0x00);
 
     //Full resolution, +/-16g, 4mg/LSB.
     accelerometer.setDataFormatControl(0x0B);
     
     //3.2kHz data rate.
     accelerometer.setDataRate(ADXL345_3200HZ);
 
     //Measurement mode.
     accelerometer.setPowerControl(0x08);
 
    while(1) {
    
             wait(0.5);
         
         accelerometer.getOutput(readings);
         
         //13-bit, sign extended values.
         pc.printf("%f, %f, %f\n\r", (float)readings[0]/65535, (float)readings[1]/65535, (float)readings[2]/65535);
 
        if ((float)readings[1]/65535 > 0.5)
        xbee1.putc('C'); //Forward
        if ((float)readings[1]/65535 < 0.5)
        xbee1.putc('D'); //Reverse
        myled = 1;
             wait_ms(100);
             myled=0;
              wait_ms(100);
   
    }
}
