/*
 * DeepPowerDown.h
 *
 *  Created on: Dec 26, 2014
 *      Author: bundgus
 */

/* AN11027
2.1.3 Deep power-down mode
In Deep Power-down mode, power and clocks are shut off to the entire chip with the
exception of the WAKEUP pin.
During Deep power-down mode, the contents of the SRAM and registers are not retained
except for a small amount of data which can be stored in five 32-bit general purpose
registers of the power management unit block.
All functional pins are tri-stated in Deep power-down mode except for the WAKEUP
pin.

On the LPC11xx, LPC11xx(L) and LPC11Cxx parts, the RESET /PIO0_0 pin needs to
be externally pulled up via 10k – 47k resistor when in deep power-down mode. If the pin
is left floating, user will see an increase in current consumption.

*/

#ifndef DEEPPOWERDOWN_H_
#define DEEPPOWERDOWN_H_

class DeepPowerDown {
public:
	DeepPowerDown();
	virtual ~DeepPowerDown();
	void powerDown();
	void setGPREG0(unsigned int newregval);
	unsigned int getGPREG0();
	void setGPREG1(unsigned int newregval);
	unsigned int getGPREG1();
	void setGPREG2(unsigned int newregval);
	unsigned int getGPREG2();
	void setGPREG3(unsigned int newregval);
	unsigned int getGPREG3();
	void setGPREG4(unsigned int newregval);
	unsigned int getGPREG4();
};

#endif /* DEEPPOWERDOWN_H_ */
