/*
 * DeepPowerDown.cpp
 *
 *  Created on: Dec 26, 2014
 *      Author: bundgus
 */

#include "DeepPowerDown.h"
#include "LPC11xx.h"

DeepPowerDown::DeepPowerDown() {
	// TODO Auto-generated constructor stub

}

DeepPowerDown::~DeepPowerDown() {
	// TODO Auto-generated destructor stub
}


void DeepPowerDown::powerDown(){

	/*
	 * Table 49.
		Register overview: PMU (base address 0x4003 8000)

		Name	Access 	Address offset 	Description 				Reset value
		PCON	R/W 	0x000 			Power control register 		0x0
		GPREG0	R/W 	0x004 			General purpose register 0 	0x0
		GPREG1 	R/W 	0x008 			General purpose register 1 	0x0
		GPREG2 	R/W 	0x00C 			General purpose register 2 	0x0
		GPREG3 	R/W 	0x010 			General purpose register 3 	0x0
		GPREG4 	R/W 	0x014 			General purpose register 4 	0x0
	 */


	// Write one to the DPDEN bit in the PCON register.
	LPC_PMU->PCON = (1 << 1) | (1 << 11);

	// Write one to the SLEEPDEEP bit in the ARM Cortex-M0 SCR register.

	SCB->SCR |= (1 << 2);		//Set SLEEPDEEP bit

	// Ensure that the IRC is powered by setting bits IRCOUT_PD and IRC_PD to zero in the PDRUNCFG register before entering Deep power-down mode.
	LPC_SYSCON->PDRUNCFG &= ~((1 << 0) | (1 << 1));

	// Deep Power Down
	__WFI();

}

void DeepPowerDown::setGPREG0(unsigned int newregval){
	LPC_PMU->GPREG0 = newregval;
}

unsigned int DeepPowerDown::getGPREG0(){
	return LPC_PMU->GPREG0;
}

void DeepPowerDown::setGPREG1(unsigned int newregval){
	LPC_PMU->GPREG1 = newregval;
}

unsigned int DeepPowerDown::getGPREG1(){
	return LPC_PMU->GPREG1;
}

void DeepPowerDown::setGPREG2(unsigned int newregval){
	LPC_PMU->GPREG2 = newregval;
}

unsigned int DeepPowerDown::getGPREG2(){
	return LPC_PMU->GPREG2;
}

void DeepPowerDown::setGPREG3(unsigned int newregval){
	LPC_PMU->GPREG3 = newregval;
}

unsigned int DeepPowerDown::getGPREG3(){
	return LPC_PMU->GPREG3;
}

void DeepPowerDown::setGPREG4(unsigned int newregval){
	LPC_PMU->GPREG4 = newregval;
}

unsigned int DeepPowerDown::getGPREG4(){
	return LPC_PMU->GPREG4;
}
