/*
 *  LPC1114_5110_PIR
 *
 *  Created on: Dec 26, 2014
 *      Author: bundgus
 *
 *	Demonstrates the use of the LPC1114_Deep_Power_Down library with the NOKIA_5110 library
 */

#include "mbed.h"
#include "DeepPowerDown.h"
#include "NOKIA_5110.h"
#include <string>

#define startup_countdown 10

// high-level hardware interfaces
DeepPowerDown pd;
DigitalOut backlight(dp18, 0);
LcdPins myLcdPins = { dp2, NC, dp6, dp26, dp25, dp24 };  // mosi, miso, sclk, dc, sce, rst
NokiaLcd myLcd( myLcdPins );
AnalogIn vref(dp9);
AnalogIn vbat(dp10);
DigitalIn personPIR(dp11);

void startup()
{
    // Turn off LCD Backlight
    backlight = 0;

    // Start the LCD
    myLcd.InitLcd();
    myLcd.ClearLcdMem();
}

void shutdown()
{
    myLcd.ShutdownLcd();
    backlight = 0;
    pd.powerDown();
}

void s_firstRun()
{
    pd.setGPREG3(1); // set next startup state to motionWake
    myLcd.SetXY(0,2);
    myLcd.DrawString("   Arming in  ");

    char cd_c[14];

    for (int cd = startup_countdown; cd>0 ; cd--) {
        myLcd.SetXY(0,3);
        myLcd.DrawString("      ");
        if (cd < 10) {
            myLcd.DrawString("0");
        }
        sprintf (cd_c, "%ld", cd);
        myLcd.DrawString(cd_c);
        myLcd.SetXY(0,4);
        myLcd.DrawString("   seconds    ");
        wait_ms(1000);
    }
}

void s_motionWake()
{

    // check a few times to make sure there isn't a delay with the person PIR after the dog PIR is triggered
    int persondetected = 3;
    while (persondetected > 0) {
        if (personPIR.read() == 1) {
            break;
        }
        wait_ms(500);
        persondetected --;
    }

    myLcd.SetXY(0,0);
    if (persondetected > 0) {
        myLcd.DrawString("    PERSON");
        pd.setGPREG1(pd.getGPREG1() + 1);
    } else {
        myLcd.DrawString("     DOG");
        pd.setGPREG0(pd.getGPREG0() + 1);
    }

    unsigned int dogct = pd.getGPREG0();
    unsigned int personct = pd.getGPREG1();

    myLcd.SetXY(0,1);
    myLcd.DrawString("   DETECTED   ");
    // buffer for gpr 0-4 register string values - 84 columns / 6 columns per char = 14
    char gpreg0_c[14];

    sprintf (gpreg0_c, "%ld", dogct);
    //myLcd.SetXY(42-((int)log10((float)dogct) + 1)*3,2);
    myLcd.SetXY(0,2);
    myLcd.DrawString("dog: ");
    myLcd.DrawString(gpreg0_c);

    sprintf (gpreg0_c, "%ld", personct);
    myLcd.SetXY(0,3);
    myLcd.DrawString("person: ");
    myLcd.DrawString(gpreg0_c);

    // analog reading for voltage reference
    sprintf (gpreg0_c, "%1.2f", 1.235/vref.read());
    myLcd.SetXY(0,5);
    myLcd.DrawString("battery: ");
    myLcd.DrawString(gpreg0_c);
    myLcd.DrawString("v");

	for (int i=0;i<50;i++){
	if (persondetected == 0) {
	backlight = !backlight;
    }
    wait_ms(100);
	}

}

int main(void)
{
    unsigned int GPREG3_i = pd.getGPREG3();  // GPREG3 = next application start state

    startup();

    switch(GPREG3_i) {
        case 0 :
            s_firstRun();
            break;
        case 1 :
            s_motionWake();
            break;
        default : /* Optional */
            break;// unknown state
    }

    shutdown();
}



