#include "mbed.h"
#include "rtos.h"
#include "USBHost.h"
#include "EthernetInterface.h"
#include "NetworkAPI/buffer.hpp"
#include "NetworkAPI/ip/address.hpp"
#include "NetworkAPI/tcp/socket.hpp"
/////////////////////////////////////////////////
// Reset time
// 1. TCP server connect error 5 times
// 2. Server send '$'
// 3. Day reset(12 or 24hours)
// 4. Server not request 10 min
/////////////////////////////////////////////////

Serial pc(USBTX, USBRX);

//DIO Setting

DigitalOut MODE1(p30);
DigitalOut MODE2(p29);
DigitalOut SEL1(p28);
DigitalOut SEL2(p27);
DigitalOut USB_S(p26);
DigitalOut TCP_S(p25);

DigitalIn S100_1(p5);
DigitalIn S100_2(p6);
DigitalIn S100_4(p7);
DigitalIn S100_8(p8);
DigitalIn S10_1(p9);
DigitalIn S10_2(p10);
DigitalIn S10_4(p11);
DigitalIn S10_8(p12);
DigitalIn S1_1(p13);
DigitalIn S1_2(p14);
DigitalIn S1_4(p15);
DigitalIn S1_8(p16);

DigitalIn MODE_S(p17);
DigitalIn SEL_S(p18);
DigitalIn SET_S(p19);

network::tcp::Socket socket;
network::Buffer buffer(256);
EthernetInterface interface;
int u_flag,u_r_done,u_r_done_buf;
int ups_connect_state,tcp_connect_state;
int ups_state,ups_time,ups_capacity;
u8 u_data[256];
u8 u_buffer[256];
char u_temp[256];
char l_temp[256];
int ms_count=0;
int m_count=0;
int day_reset_flag=0;
int rq_reset_flag=2;

extern "C" void mbed_reset();
int event_state = 0;
int d_reset[3]={0,12,24};
int r_reset[3]={0,5,10};
int server_rq_count;
void display_ups_state(void);
//TCP thread
void TCP_thread(void const *args)
{
    tcp_connect_state = TCP_DISCONNECT;
    server_rq_count=0;
    printf(">TCP thread start\r\n");
    int result;
    int rc_count=0;
    int id=21;
    char ip[15];
    std::string request("@");
    
    
    //IP SET
    id = (100*((S100_1*1)+(S100_2*2)))+(10*((S10_1*1)+(S10_2*2)+(S10_4*4)+(S10_8*8)))+((S1_1*1)+(S1_2*2)+(S1_4*4)+(S1_8*8));
    snprintf(ip,sizeof(ip),"192.168.205.%d",id);
    interface.init((char *)ip,"255.255.0.0","192.168.1.1");
    //Ether set    
    interface.connect();
    printf("IP Address is %s\n\r", interface.getIPAddress());
        
    //Socket open
    if(socket.open() < 0) {
        printf("Failed to open TCP Socket\n\r");
        
    }
    //Socket connect - 5 time retry and reset
    do{
        if( (result = socket.connect("192.168.200.11", 7900))< 0){ 
            if(rc_count>=5)
                mbed_reset();
          
            printf("Failed to connect with Server(%d)\n\r",result);
            rc_count++;
        }
        
        
    }    
    while(result<0);
    tcp_connect_state = TCP_CONNECT;
    TCP_S = 1;
    
    //Send Connection message to server
    if (socket.write((void *)request.data(), request.size()) < 0) {
        printf("Failed to write request\n\r");
        
    }
    
    //Recieve Loop
    do
    {
        result = socket.read(buffer);
        strcpy((char *)u_buffer, (char *)buffer.data());
        
        printf("Received %d bytes:\n\r%s\n\r", result, (char *)buffer.data());
        //Data request
        if(u_buffer[0] == '!'){
                   
            
            socket.write((void *)u_temp, sizeof(u_temp));
        }
        //reset
        else if(u_buffer[0] == '$'){
            printf("Reset bye bye!!\r\n");
            Thread::wait(1000);
            mbed_reset();
        }
        server_rq_count=0;
    } while(result > 0);
    
    socket.close();
    
    
}

//Time&Event thread
void Event_thread(void const *args)
{
    printf(">Event thread start\r\n");
    int push_count = 0;
    string menu[3]={"OFF","ON 12H","ON 24H"};
    string r_menu[3]={"OFF","ON 5min","ON 10min"};
 
    
    while(1){
    //Nomal state    
        if(event_state == 0){
            //Day setting 
            if(MODE_S){
                while(MODE_S){
                   push_count++;
                   if(push_count > 20){
                     event_state = 1;
                     if(day_reset_flag == 1){
                         MODE1 = 1;
                         MODE2 = 0;
                         SEL1 = 1;
                         SEL2 = 0;
                     }
                    else if(day_reset_flag == 2){
                         MODE1 = 1;
                         MODE2 = 0;
                        SEL1 = 0;
                        SEL2 = 1;
                    }
                    else{
                        MODE1 = 1;
                        MODE2 = 0;
                        SEL1 = 0;
                        SEL2 = 0;
                    }
                    while(MODE_S);
                         break;
                    }
                    
                    Thread::wait(100);
                }
                
                push_count=0;
            }
            
            else if(ms_count >60000)
                ms_count=0;
            //ups data get
            else if((ups_connect_state==UPS_CONNECT)&&(ms_count%50==0)){
                //Min count
                if(ms_count%600==0){
                    m_count++;
                    server_rq_count++;
                    //reset
                    if(((m_count >= 60*d_reset[day_reset_flag])&&(day_reset_flag>0))||((server_rq_count>=r_reset[rq_reset_flag])&&(rq_reset_flag>0))){
                        printf("Reset bye bye!!\r\n");
                        
                        Thread::wait(1000);
                        mbed_reset();
                    }
                    
                    
                        
                }
                printf(">Push %d %d\r\n",ms_count,m_count);
                
                u_flag = 1;
                            
            }
            
        }
        //day reset setting state
        else if(event_state == 1){
             if(day_reset_flag == 1){
                 MODE1 = 1;
                 MODE2 = 0;
                 SEL1 = 1;
                 SEL2 = 0;
             }
             else if(day_reset_flag == 2){
                 MODE1 = 1;
                 MODE2 = 0;
                 SEL1 = 0;
                 SEL2 = 1;
            }
            else{
                 MODE1 = 1;
                 MODE2 = 0;
                 SEL1 = 0;
                 SEL2 = 0;
            }    
            
            if(MODE_S){
                while(MODE_S);
                   event_state = 2;
            }
                        
            
            else if(SEL_S){
                while(SEL_S);
                day_reset_flag++;
                if(day_reset_flag>2)
                    day_reset_flag =0;
            }
            //Day reset set
            else if(SET_S){
                while(SET_S);
                event_state = 0;
                MODE1 = 0;
                MODE2 = 0;
                SEL1 = 0;
                SEL2 = 0;
                
                display_ups_state();
            }
       }
       //TCP reset setting
       else if(event_state==2){
            for(int i=0;i<3;i++){
                if(rq_reset_flag == 1){
                    MODE1 = 0;
                    MODE2 = 1;
                    SEL1 = 1;
                    SEL2 = 0;
                }
                else if(rq_reset_flag == 2){
                    MODE1 = 0;
                    MODE2 = 1;
                    SEL1 = 0;
                    SEL2 = 1;
                }
                else{
                    MODE1 = 0;
                    MODE2 = 1;
                    SEL1 = 0;
                    SEL2 = 0;
                }
                
            }
            if(SEL_S){
                while(SEL_S);
                rq_reset_flag++;
                if(rq_reset_flag>2)
                    rq_reset_flag =0;
            }
            //Day reset set
            else if(SET_S){
                while(SET_S);
                event_state = 0;
                MODE1 = 0;
                MODE2 = 0;
                SEL1 = 0;
                SEL2 = 0;
                display_ups_state(); 
            }
        }
        
            ms_count++;
            Thread::wait(95);
    }
}
void display_ups_state(void)
{
    if(ups_connect_state == UPS_CONNECT)
        USB_S = 1;
    else
        USB_S = 0;
                    
    if(tcp_connect_state == TCP_CONNECT)
        TCP_S = 1;
    else
        TCP_S = 0;
    switch(u_data[0])
    { 
        case(8): { ups_state = ALLOFF;printf("[All Off]hx%02X",u_data[0]); snprintf(l_temp,sizeof(l_temp),"[All Off] %d%% %dsec \n",ups_capacity,ups_time);break;}
        case(10): { ups_state = BATTERY;printf("[Battery]hx%02X",u_data[0]); snprintf(l_temp,sizeof(l_temp),"[Battery] %d%% %dsec \n",ups_capacity,ups_time);break;}
        case(12): { ups_state = ONLINE;printf("[Online]hx%02X",u_data[0]); snprintf(l_temp,sizeof(l_temp),"[Online] %d%% %dsec \n",ups_capacity,ups_time);break;}
        case(13): { ups_state = ONLINE;printf("[Online]hx%02X",u_data[0]); snprintf(l_temp,sizeof(l_temp),"[Online] %d%% %dsec \n",ups_capacity,ups_time);break;}
        case(14): { ups_state = ONLINE;printf("[Online]hx%02X",u_data[0]); snprintf(l_temp,sizeof(l_temp),"[Online] %d%% %dsec \n",ups_capacity,ups_time);break;}
        default: {snprintf(l_temp,sizeof(l_temp),"?????");};
    } 
    
    if(day_reset_flag>0){
        SEL1=1;
        SEL2=1;
    }
    else{
        SEL1=0;
        SEL2=0;
    }
        
}

int main(void)
{
    Serial pc(USBTX, USBRX);
    pc.baud(460800);
    u_r_done = 0;
    std::string u_sdata;
    wait(3);
    
    
    printf("\r\n==== mbed program start ====\r\n");
    display_ups_state();
    //Thread start
    Thread th_console_out1(TCP_thread);
    wait(0.5);
    Thread th_console_out2(Event_thread);
    wait(0.5);
    printf(">USB Host start\r\n");
    snprintf(u_temp,sizeof(u_temp),"!,%d,%d,%d,%d# \n",ups_connect_state,ups_state,ups_capacity,ups_time);
    USBInit();
    std::string request("TEST\r\n\r\n");
    //USB Loop
    for (;;){
     u_r_done = USBLoop(u_flag,u_data);
        //Get report
        if(u_r_done==UPS_REPORT){
            u_r_done_buf = u_r_done;
            ups_capacity = u_data[1];
            ups_time = u_data[2]+u_data[3]*256;
           
            printf("  [Battery Capacity : %d]hx%02X",u_data[1],u_data[1]);
            printf("  [Battery Time : %d]hx%02X hx%02X",(u_data[2]+u_data[3]*256),u_data[2],u_data[3]);         
            printf("\n"); 
            snprintf(u_temp,sizeof(u_temp),"!,%d,%d,%d,%d# \n",ups_connect_state,ups_state,ups_capacity,ups_time);
            display_ups_state();
            u_flag = 0;
        }
        
        else if(u_r_done==UPS_CONNECT){
            ups_connect_state = UPS_CONNECT;
            USB_S = 1;
            
        }
        else if(u_r_done==UPS_DISCONNECT){
            ups_connect_state = UPS_DISCONNECT;
            USB_S = 1;
            
        }
     }
        
    printf("=== mbed program end ====\r\n");
    exit(1);
}


