#include "mbed.h"
#include "const.h"
#include "ur_Bertl.h"

Serial bt(p9, p10);

const int blinkTime = 200; // ms

class BlinkBertl : public Bertl
{
public:
    void BlinkLeftLed();
    void BlinkRigthLed();
};

void BlinkBertl::BlinkLeftLed()
{
    for(int i = 0; i < 3; i++) {
        TurnLedOn(LED_FL2 | LED_BL1);
        wait_ms(blinkTime);
        TurnLedOff(LED_ALL);
        wait_ms(blinkTime);
    }
}

void BlinkBertl::BlinkRigthLed()
{
    for(int i = 0; i < 3; i++) {
        TurnLedOn(LED_FR2 | LED_BR1);
        wait_ms(blinkTime);
        TurnLedOff(LED_ALL);
        wait_ms(blinkTime);
    }
}

int main()
{
    char cmd, b1, b3;
    bool turn = false;

    BlinkBertl karel;

    bt.printf("Kommands 1:Move, 3:TurnLeft, 5:TurnRight, 7:MoveBack, 6 and 8 stepwise turns \n");
    /*    karel.Move();
        karel.TurnLeft();
        karel.TurnRigth();
        karel.MoveBackwards();
    */
    karel.TurnLedOn(LED_ALL);
    wait_ms(200);
    karel.TurnLedOff(LED_ALL);
    wait_ms(200);
    while(karel.WaitUntilButtonPressed()) {}
    wait(1);
    while(karel.WaitUntilButtonPressed())
    {
        karel.NibbleLeds(karel.GetLineValues());
        switch(karel.GetLineValues())
        {
        case 0x00:
            karel.TurnLeftStep(50);
            break;
        case 0x03: case 0x01: case 0x07:
            karel.TurnLeftStep(20);
            break;
        case 0x0E: case 0x0A: case 0x08:
            karel.TurnRigthStep(20);
            break;
        default:
            karel.Move(20);
            break;
        }
        if(!karel.FrontIsClear())
            karel.TurnLeftStep(1000);
    }
    while(true) {
        if (bt.readable()) {
            b1 = bt.getc();
            cmd = bt.getc();
            b3 = bt.getc();
            //bt.printf("3 Getchar: %x %x %x\n", b1, cmd ,b3);
            karel.NibbleLeds(karel.GetLineValues());
            switch (cmd) {
                case '1':
                    karel.Move();
                    break;
                case '3':
                    karel.TurnLeft();
                    break;
                case '5':
                    karel.TurnRigth();
                    break;
                case '7':
                    karel.MoveBackwards();
                    break;
                case '6':
                    karel.TurnLeftStep();
                    break;
                case '8':
                    karel.TurnRigthStep();
                    break;
                case '0':
                    karel.BlinkLeftLed();
                    break;
                case '2':
                    karel.BlinkRigthLed();
                    break;
                default:
                    break;
            }
            if(cmd == '9' && turn)
            {
                turn = !turn;
                karel.TurnLedOff(LED_ALL);
            } else if(cmd == '9' && !turn)
            {
                turn = !turn;
                karel.TurnLedOn(LED_ALL);
            }
            
        }
    }
}