#include "mbed.h"

// ---------------- Inherited Switch Event Class from InterruptIn --------------------------
class SwEventInh : public InterruptIn {
        //InterruptIn _isr;
        volatile int16_t _pressed;
        void _risingISR();
 
    public:
        SwEventInh(PinName pin) : InterruptIn(pin) {          // create the InterruptIn on the pin specified to SwEvent
            rise(callback(this, &SwEventInh::_risingISR));  // attach ISR-function of this SwEvent instance 
            _pressed=0;     
        }
        int checkFlag();                            // must in do-condition (while(true)-loop) continuously interrogated
};
// ---------------- Switch Event Class Methodes --------------------------
int SwEventInh::checkFlag() {
    if( _pressed ) {
        _pressed = 0; 
        return 1;
    }
    return 0;
}
 
void SwEventInh::_risingISR() {            
    if( read() )
        _pressed = 1;
}


// ---------------- Switch Event Class  --------------------------
class SwEvent {
        InterruptIn _isr;
        volatile int16_t _pressed;
        void _risingISR();
 
    public:
        SwEvent(PinName pin) : _isr(pin) {          // create the InterruptIn on the pin specified to SwEvent
            _isr.rise(callback(this, &SwEvent::_risingISR));  // attach ISR-function of this SwEvent instance 
            _pressed=0; 
        }
        int checkFlag();                            // must in do-condition (while(true)-loop) continuously interrogated
};
// ---------------- Switch Event Class Methodes --------------------------
int SwEvent::checkFlag() {
    if( _pressed ) {
        _pressed = 0; 
        return 1;
    }
    return 0;
}
 
void SwEvent::_risingISR() {            
    if( _isr.read() )
        _pressed = 1;
}

SwEventInh sw1(p14);

DigitalOut myled(LED1);
DigitalOut myled2(LED2);

int main() {
    myled = 1;
    wait(1);
    myled = 0;
    printf("Hello SwEvent v0.1\n");
    while(1) {
        sw1.read();
        if(sw1.checkFlag())
            myled = ! myled; 
    }
}
