#include "mbed.h"

class MyClass
{
public:
    MyClass(double messwert) : _messwert(messwert) { }
    MyClass() : _messwert(0.0) { }

    void status()
    {
        printf("%f\n", _messwert);
    }
private:
    double _messwert;
};

class MyClassB
{
private:
    I2C i2c;
    float result;

public:
    MyClassB(PinName sda, PinName scl) : i2c(sda, scl){
        result = 0;
    }
    float read();
};

float MyClassB::read() {
    return result;
}

MyClass myClass(0.0);
MyClassB sensor(p28, p27);

int main() {
    myClass.status();
    wait_ms(100);

    printf("Sensorwert: %f \n", sensor.read());
}
