#include "mbed.h"
#include "EthernetInterface.h"
#include "string.h"

DigitalOut led1(LED1);

#define ECHO_SERVER_PORT   9050

int main (void) {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("\nServer IP Address is %s\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    while (true) {
        printf("\nWait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        //client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n",buffer);
            
            if(strstr(buffer, "On1"))
                led1 = 1;
            if(strstr(buffer, "Off1"))
                led1 = 0;
            
            // reverse the message
            /*char temp;
            for(int f = 0, l = n-1; f<l; f++,l--){
                temp = buffer[f];
                buffer[f] = buffer[l];
                buffer[l] = temp;
                }
            */
            // print reversed message to terminal
            printf("Sending message to Client: '%s'\n","OK");
            
            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        
        client.close();
    }
}
