/*  State Machine Implementierung für einen Lichtschalter
    simuliert durch den Rot-Anteil der RGB-Led und dem Taster sw1
    siehe: https://developer.mbed.org/users/fpucher/code/HIM0Board/wiki/STM-Schalter
*/

#include "mbed.h"

PwmOut red(p36);
PwmOut green(p5);
PwmOut blue(p34);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn sw2(P0_10);
DigitalIn sw3(P0_23);
DigitalIn sw4(P1_16);

// States
const int ST_EIN = 1;
const int ST_AUS = 2;

// ---------------------- Event Klasse ------------------------
class Event
{
    bool _pressed;
    InterruptIn _isr;
public:
    Event( PinName pin ) : _isr(pin) {
        _pressed = false;
        _isr.rise(this, &Event::_RisingIsr);
    }

    void _RisingIsr() {
        if( _isr.read())
            _pressed = true;
    }

    bool CheckFlag() {
        if( _pressed ) {
            _pressed = false;
            return true;
        }
        return false;
    }

};

class Rgb
{
    PwmOut _red;
public:
    Rgb( PinName red ) : _red(red) {}
    void LedOn() {
        _red = 0;
    }

    void Dimm() {
        //_red = 0;
        for(float i=0.0; i <= 1.0; i+= 0.1) {
            _red = i;
            wait_ms(200);
        }
    }

    void LedOff() {
        _red = 1;
    }
};
// ----------------------- STM Klasse ---------------------------

Event sw1(P0_15);
Rgb rgb(p36);

class Stm {
    public:
        Stm() { state = ST_AUS; }
        void Ein();
        void Aus();
        
        int state;
};

void Stm::Ein()
{
    // entry
    // do
    while(true){
        rgb.LedOn();
        // exit
        if(sw1.CheckFlag()) {
            state = ST_AUS;
            return;
        }
    }
}

void Stm::Aus()
{
    // entry
    // do
    while(true){
        rgb.LedOff(); 
        // exit
        if(sw1.CheckFlag()) {
            state = ST_EIN;
            return;
        }
    }
}

//--------------------------- Hauptprogramm ------------------------

Stm stm;

void stateMachine()
{
    switch( stm.state )
    {
        case ST_EIN: stm.Ein();
            break;
        case ST_AUS: stm.Aus();
            break;
    }
}
    
int main()
{
    blue=green=1;
 
    while(true) {
        stateMachine();
    }
}