#include "mbed.h"

//DigitalOut myled(LED1);

class MyLed {
    DigitalOut _led;
public:
    MyLed(PinName pin) :  _led(pin) { }
    
    void LedOn()  { _led = 1; } 
    void LedOff() { _led = 0; }
};

// Bei drücken eines Tasters soll eine ISR aufgerufen werden
// bool CheckFlag();  // soll true zurück geben, wenn eine Taste gedrückt wurde

class Event {
    InterruptIn _isr;
    bool _pressed;
public:
    Event(PinName pin) : _isr(pin) {
        _isr.rise(this, &Event::rise);
        _pressed = false;
    }
        
    void rise() {
        _pressed = true;
    }
    
    bool CheckFlag() {
        if(_pressed) {
            _pressed=false;
            return true;
        }
        return false;
    }
};

class RgbLed {
    PwmOut _g;
    PwmOut _b;
    PwmOut _r;
public:
    RgbLed(PinName g, PinName b, PinName r) :  _g(g), _b(b), _r(r) { }
    
    void write(float g, float b, float r) {
        _g = g;
        _b = b;
        _r = r;
    }
};

MyLed myled2(LED1);
MyLed myled3(LED3);
RgbLed myled(P0_9, P1_15, P0_21); // g, b, r
Event sw1(P0_10);

int main() {
    while(1) {
        if(sw1.CheckFlag()) {
            myled3.LedOn();
            wait(0.5f);
            myled3.LedOff();
        }
        
        myled.write(0.1, 0.2, 0.3);
        myled2.LedOn();
        wait(0.2);
        myled2.LedOff();
        wait(0.2);

    }
}
