/***********************************
name:   BERTL14_UART
author: Wolfgang Raimann
email:  rai@bulme.at
description:
    Schreibt nach einem Reset "Welcome to BERTL14". Danach gibt er die eingegeben Zeichen zurück.
    Zusätzlich werden Großbuchstaben in Kleinbuchstaben und umgekehrt umgewandelt.
    Einzustellen am PC: 9600 Baud; 8 Databit; 1 Stopp Bit; None Parity
***********************************/

#include "mbed.h"

Serial pc(USBTX, USBRX);

int main() {
    char readChar = 0;
    pc.printf("Welcome to BERTL14\n\r");
    while(1) {
        readChar = pc.getc();
        if(readChar >= 65 && readChar <= 90){ // Großbuchstaben in Kleinbuchstaben umwandeln
            pc.putc(readChar + 32);
        } else if(readChar >= 97 && readChar <= 122){ // Kleinbuchstaben in Großbuchstaben umwandeln
            pc.putc(readChar - 32);
        } else {    // Sonst schicke was gekommen ist
            pc.putc(readChar);
        }
    }
}
