/***********************************
name:   BERTL14_I2C_TEST
author: Wolfgang Raimann
email:  rai@bulme.at
description:
    Die Taster vom I2C Expander werden direkt auf die LED's des Expander geschalten
***********************************/

#include "mbed.h"

const int PCA9555_ADR = 0x40;
#define I2C_WRITE   0
#define I2C_READ    1

I2C i2c(p28, p27);


int main() {
    char btn = 0;
    // Config PCA9555 I0 as output    
    i2c.start();
    i2c.write(PCA9555_ADR + I2C_WRITE);
    i2c.write(0x06);
    i2c.write(0x00);
    i2c.stop();    
    
    while(1) {
        // Einlesen der Taster
        i2c.start();
        i2c.write(PCA9555_ADR + I2C_WRITE);
        i2c.write(0x01);
        i2c.start();
        i2c.write(PCA9555_ADR + I2C_READ);
        btn = i2c.read(0);
        i2c.stop();
        // Schreiben auf die LED's
        i2c.start();
        i2c.write(PCA9555_ADR + I2C_WRITE);
        i2c.write(0x02);
        i2c.write(~btn);
        i2c.stop();
    }
}
