#include <jsonlite.h>
#include "M2XStreamClient.h"

#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"  //I2C Temperature Sensor

char feedId[] = "bb84147dbab191356d0b5fb090c19a9e"; // Feed you want to post to
char m2xKey[] = "f68404a95d271e5d81c4d7f9224cbd8d"; // Your M2X access key
char streamNameShirt[] = "shirtposition"; // Stream you want to post to
char streamNamePants[] = "pantsposition";

DigitalOut led(LED_RED);
DigitalOut bled(LED_BLUE);

Serial uart0(USBTX, USBRX);
Serial uart3(PTC17, PTC16);

int shirtPosition = 0;
int pantsPosition = 0;

int topPackage = 0;
int bottomPackage = 0;
int totalPackage = 0; 

Client client;
M2XStreamClient m2xClient(&client, m2xKey);

EthernetInterface eth;

void on_data_point_found_shirt(const char* at,const char* value, int index, void* context) {
  //printf("Found a data point, index: %d\r\n", index);
  //printf("At: %s Value: %s\r\n", at, value);
  
  if(index == 0)
  {
    shirtPosition = atoi(value);
    
    if(shirtPosition < 7 && shirtPosition > 0)
    {
        uart0.printf("%x", shirtPosition);
        uart3.printf("%x", shirtPosition);
    }
  }
}
void on_data_point_found_pants(const char* at,const char* value, int index, void* context) {
  //printf("Found a data point, index: %d\r\n", index);
  //printf("At: %s Value: %s\r\n", at, value);
  
  if(index == 0)
  {
    pantsPosition = atoi(value) + 6;
    
    if(pantsPosition < 13 && pantsPosition > 6)
    {
        uart0.printf("%x", pantsPosition);
        uart3.printf("%x", pantsPosition);
    }


  }
}

int main() {
  
  led = 0;
  
  eth.init();
  eth.connect();
  printf("IP Address: %s\r\n", eth.getIPAddress());
  
  while (true) {
  

    int response1 = m2xClient.fetchValues(feedId, streamNameShirt, on_data_point_found_shirt, NULL, NULL, NULL, "1");
    int response2 = m2xClient.fetchValues(feedId, streamNamePants, on_data_point_found_pants, NULL, NULL, NULL, "1");
    //printf("Fetch response code: %d\r\n", response);
    if (response1 == -1 || response2 == -1 ) 
        bled = 0;
    else 
        bled = 1;
    
    led = !led;

    // wait 5 secs and then loop
    delay(2000);  // was originally 2000
  }
}