#include <jsonlite.h>
#include "M2XStreamClient.h"

#include "mbed.h"
#include "EthernetInterface.h"
#include "LM75B.h"  //I2C Temperature Sensor


char feedId[] = "c6eabf437b8c69efbb4e4a8d5c60c04d"; // Feed you want to post to
char m2xKey[] = "10bc8a4dc4a37c5dc549b41ffaa6d6c1"; // Your M2X access key
char streamName[] = "danger_bit"; // Stream you want to post to

DigitalOut garage(PTB9);
DigitalOut led(LED_RED);
DigitalOut bled(LED_BLUE);

/*
char feeidId[] = "08a3bceeee7e7bfa32340aadd282ea23"; // Feed you want to post to
char m2xKey[] = "41e5905679b7a6fa668303e00da65826"; // Your M2X access key
char streamName[] = "garagecommand"; // Stream you want to post to
*/
int danger = 0;

Client client;
M2XStreamClient m2xClient(&client, m2xKey);

EthernetInterface eth;

void on_data_point_found(const char* at, const char* value, int index, void* context) {
  printf("Found a data point, index: %d\r\n", index);
  printf("At: %s Value: %s\r\n", at, value);
  
  if(index == 0)
  {
    danger = atoi(value);
    
    if (danger == 1)
    {
        printf("Carbonmonoxide levels are dangerous. \n");
        garage = 0;
        
    }
    
    if (danger == 0)
    {
        garage = 1;
    }
    
  }
}

void on_location_found(const char* name,
                       double latitude,
                       double longitude,
                       double elevation,
                       const char* timestamp,
                       int index,
                       void* context) {
  printf("Found a location, index: %d\r\n", index);
  printf("Name: %s  Latitude: %lf  Longitude: %lf\r\n", name, latitude, longitude);
  printf("Elevation: %lf  Timestamp: %s\r\n", elevation, timestamp);
}

int main() {
  garage = 1; 
  led = 0;
  
  eth.init();
  eth.connect();
  printf("IP Address: %s\r\n", eth.getIPAddress());

  char amb_temp[6];
  
  
  while (true) {
  
    // read temperature
    int response = m2xClient.fetchValues(feedId, streamName, on_data_point_found, NULL, NULL, NULL, "1");
    printf("Fetch response code: %d\r\n", response);
    if (response == -1) 
        bled = 0;
    else 
        bled = 1;
    
    led = !led;

    // wait 5 secs and then loop
    delay(2000);
  }
}