#include "Motor.h"
#include "mbed.h"


Motor::Motor(PinName pwm, PinName dir1, PinName dir2): _pwm(pwm), _dir1(dir1), _dir2(dir2)
{
    _direction=1;           //default fwd
    _pwm.period(0.00005);   //20Khz
    _pwm = 0;               //default pwm off
    _dir1 = 0;
    _dir2 = 0;

}

float Motor::speed(float speed, bool direction)
{
    if(direction == true) {
        _dir1=1;
        _dir2=0;
    } else {
        _dir1=0;
        _dir2=1;
    }
    if(speed > 1) {
        speed = 1;
    }
    if(speed < -1) {
        speed = -1;
    }

    _pwm = abs(speed);
    return speed;
}

float Motor::speed(float speed)
{
    if(speed > 1) {
        speed = 1;
    }
    if(speed < -1) {
        speed = -1;
    }
    if(speed < 0) {
        _dir1=1;
        _dir2=0;
    } else {
        _dir1=0;
        _dir2=1;
    }
    _pwm = abs(speed);
    return speed;
}

Motor& Motor::operator= (float speed)
{
    if(speed > 1) {
        speed = 1;
    }
    if(speed < -1) {
        speed = -1;
    }
    if(speed < 0) {
        _dir1=1;
        _dir2=0;
    } else {
        _dir1=0;
        _dir2=1;
    }
    _pwm = abs(speed);
    return *this;
}
